/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.SimpleDataSourceDescriptor;
import se.unlogic.hierarchy.core.daos.interfaces.DataSourceDAO;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.populators.annotated.AnnotatedResultSetPopulator;

public class MySQLDataSourceDAO
extends AnnotatedDAO<SimpleDataSourceDescriptor>
implements DataSourceDAO {
    private static final AnnotatedResultSetPopulator<SimpleDataSourceDescriptor> POPULATOR = new AnnotatedResultSetPopulator(SimpleDataSourceDescriptor.class);

    protected MySQLDataSourceDAO(DataSource ds) {
        super(ds, SimpleDataSourceDescriptor.class, null, POPULATOR, new QueryParameterPopulator[0]);
    }

    @Override
    public ArrayList<SimpleDataSourceDescriptor> getAll() throws SQLException {
        return new ArrayListQuery(this.dataSource.getConnection(), true, "SELECT * FROM openhierarchy_data_sources ORDER BY name, username", POPULATOR).executeQuery();
    }

    @Override
    public ArrayList<SimpleDataSourceDescriptor> getAll(boolean enabled) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource.getConnection(), true, "SELECT * FROM openhierarchy_data_sources WHERE enabled = ? ORDER BY name, username", POPULATOR);
        query.setBoolean(1, enabled);
        return query.executeQuery();
    }

    @Override
    public SimpleDataSourceDescriptor get(Integer dataSourceID) throws SQLException {
        ObjectQuery query = new ObjectQuery(this.dataSource.getConnection(), true, "SELECT * FROM openhierarchy_data_sources WHERE dataSourceID = ? ORDER BY name, username", POPULATOR);
        query.setInt(1, dataSourceID.intValue());
        return (SimpleDataSourceDescriptor)query.executeQuery();
    }

    public void add(SimpleDataSourceDescriptor bean, TransactionHandler transactionHandler) throws SQLException {
        super.add((Object)bean, transactionHandler, null);
    }

    public void update(SimpleDataSourceDescriptor bean, TransactionHandler transactionHandler) throws SQLException {
        super.update((Object)bean, transactionHandler, null);
    }

    public SimpleDataSourceDescriptor get(Integer dataSourceID, TransactionHandler transactionHandler) throws SQLException {
        ObjectQuery query = transactionHandler.getObjectQuery("SELECT * FROM openhierarchy_data_sources WHERE dataSourceID = ? ORDER BY name, username", POPULATOR);
        query.setInt(1, dataSourceID.intValue());
        return (SimpleDataSourceDescriptor)query.executeQuery();
    }

    public List<SimpleDataSourceDescriptor> getAll(TransactionHandler transactionHandler) throws SQLException {
        return super.getAll((HighLevelQuery)null, transactionHandler);
    }
}

