/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.io.IOException;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.core.beans.SimpleBackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleFilterModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.daos.factories.CoreDaoFactory;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLBackgroundModuleDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLBackgroundModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLDataSourceDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLFilterModuleDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLFilterModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLForegroundModuleDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLForegroundModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLMenuIndexDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleAttributeDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLSectionAttributeDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLSectionDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLVirtualMenuItemDAO;
import se.unlogic.hierarchy.core.daos.interfaces.AttributeDAO;
import se.unlogic.hierarchy.core.daos.interfaces.FilterModuleDAO;
import se.unlogic.hierarchy.core.daos.interfaces.FilterModuleSettingDAO;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableUpgradeException;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;

public class MySQLCoreDAOFactory
implements CoreDaoFactory {
    protected static Logger log = Logger.getLogger(CoreDaoFactory.class);
    private MySQLDataSourceDAO dataSourceDAO;
    private MySQLMenuIndexDAO menuIndexDAO;
    private MySQLForegroundModuleDAO foregroundModuleDAO;
    private MySQLBackgroundModuleDAO backgroundModuleDAO;
    private MySQLFilterModuleDAO filterModuleDAO;
    private MySQLFilterModuleSettingDAO filterModuleSettingDAO;
    private MySQLForegroundModuleSettingDAO foregroundModuleSettingDAO;
    private MySQLBackgroundModuleSettingDAO backgroundModuleSettingDAO;
    private MySQLModuleAttributeDAO<SimpleForegroundModuleDescriptor> foregroundModuleAttributeDAO;
    private MySQLModuleAttributeDAO<SimpleBackgroundModuleDescriptor> backgroundModuleAttributeDAO;
    private MySQLModuleAttributeDAO<SimpleFilterModuleDescriptor> filterModuleAttributeDAO;
    private MySQLSectionAttributeDAO<SimpleSectionDescriptor> sectionAttributeDAO;
    private MySQLSectionDAO sectionDAO;
    private MySQLVirtualMenuItemDAO virtualMenuItemDAO;

    @Override
    public void init(DataSource dataSource) throws TableUpgradeException, SQLException, SAXException, IOException, ParserConfigurationException {
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)this.getClass().getName(), (DBScriptProvider)new XMLDBScriptProvider(this.getClass().getResourceAsStream("MySQL DB script.xml")));
        if (upgradeResult.isUpgrade()) {
            log.info((Object)upgradeResult.toString());
        }
        this.dataSourceDAO = new MySQLDataSourceDAO(dataSource);
        this.menuIndexDAO = new MySQLMenuIndexDAO(dataSource);
        this.virtualMenuItemDAO = new MySQLVirtualMenuItemDAO(dataSource);
        this.backgroundModuleSettingDAO = new MySQLBackgroundModuleSettingDAO(dataSource);
        this.filterModuleSettingDAO = new MySQLFilterModuleSettingDAO(dataSource);
        this.foregroundModuleSettingDAO = new MySQLForegroundModuleSettingDAO(dataSource);
        this.backgroundModuleAttributeDAO = new MySQLModuleAttributeDAO(dataSource, "openhierarchy_background_module_attributes");
        this.filterModuleAttributeDAO = new MySQLModuleAttributeDAO(dataSource, "openhierarchy_filter_module_attributes");
        this.foregroundModuleAttributeDAO = new MySQLModuleAttributeDAO(dataSource, "openhierarchy_foreground_module_attributes");
        this.sectionAttributeDAO = new MySQLSectionAttributeDAO(dataSource, "openhierarchy_section_attributes");
        this.backgroundModuleDAO = new MySQLBackgroundModuleDAO(dataSource, this.backgroundModuleSettingDAO, this.backgroundModuleAttributeDAO);
        this.filterModuleDAO = new MySQLFilterModuleDAO(dataSource, this.filterModuleSettingDAO, this.filterModuleAttributeDAO);
        this.foregroundModuleDAO = new MySQLForegroundModuleDAO(dataSource, this.foregroundModuleSettingDAO, this.foregroundModuleAttributeDAO);
        this.sectionDAO = new MySQLSectionDAO(dataSource, this.sectionAttributeDAO);
    }

    @Override
    public MySQLDataSourceDAO getDataSourceDAO() {
        return this.dataSourceDAO;
    }

    @Override
    public MySQLMenuIndexDAO getMenuIndexDAO() {
        return this.menuIndexDAO;
    }

    @Override
    public MySQLForegroundModuleDAO getForegroundModuleDAO() {
        return this.foregroundModuleDAO;
    }

    @Override
    public MySQLBackgroundModuleDAO getBackgroundModuleDAO() {
        return this.backgroundModuleDAO;
    }

    @Override
    public MySQLForegroundModuleSettingDAO getForegroundModuleSettingDAO() {
        return this.foregroundModuleSettingDAO;
    }

    @Override
    public MySQLBackgroundModuleSettingDAO getBackgroundModuleSettingDAO() {
        return this.backgroundModuleSettingDAO;
    }

    @Override
    public MySQLSectionDAO getSectionDAO() {
        return this.sectionDAO;
    }

    @Override
    public MySQLVirtualMenuItemDAO getVirtualMenuItemDAO() {
        return this.virtualMenuItemDAO;
    }

    @Override
    public FilterModuleSettingDAO getFilterModuleSettingDAO() {
        return this.filterModuleSettingDAO;
    }

    @Override
    public FilterModuleDAO getFilterModuleDAO() {
        return this.filterModuleDAO;
    }

    @Override
    public AttributeDAO<SimpleForegroundModuleDescriptor> getForegroundModuleAttributeDAO() {
        return this.foregroundModuleAttributeDAO;
    }

    @Override
    public AttributeDAO<SimpleBackgroundModuleDescriptor> getBackgroundModuleAttributeDAO() {
        return this.backgroundModuleAttributeDAO;
    }

    @Override
    public AttributeDAO<SimpleFilterModuleDescriptor> getFilterModuleAttributeDAO() {
        return this.filterModuleAttributeDAO;
    }

    @Override
    public AttributeDAO<SimpleSectionDescriptor> getSectionAttributeDAO() {
        return this.sectionAttributeDAO;
    }
}

