/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.SimpleBackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLBackgroundModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleAttributeDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.interfaces.BackgroundModuleDAO;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.db.DBUtils;

public class MySQLBackgroundModuleDAO
extends AnnotatedDAO<SimpleBackgroundModuleDescriptor>
implements BackgroundModuleDAO {
    protected final MySQLBackgroundModuleSettingDAO moduleSettingDAO;
    protected final MySQLModuleAttributeDAO<SimpleBackgroundModuleDescriptor> moduleAttributeDAO;
    protected final QueryParameterFactory<SimpleBackgroundModuleDescriptor, Boolean> enabledQueryParameterFactory;
    protected final QueryParameterFactory<SimpleBackgroundModuleDescriptor, Integer> moduleIDQueryParameterFactory;
    protected final QueryParameterFactory<SimpleBackgroundModuleDescriptor, Integer> sectionIDQueryParameterFactory;

    public MySQLBackgroundModuleDAO(DataSource dataSource, MySQLBackgroundModuleSettingDAO moduleSettingDAO, MySQLModuleAttributeDAO<SimpleBackgroundModuleDescriptor> moduleAttributeDAO) {
        super(dataSource, SimpleBackgroundModuleDescriptor.class, (AnnotatedDAOFactory)new SimpleAnnotatedDAOFactory());
        this.moduleSettingDAO = moduleSettingDAO;
        this.moduleAttributeDAO = moduleAttributeDAO;
        this.enabledQueryParameterFactory = this.getParamFactory("enabled", Boolean.TYPE);
        this.moduleIDQueryParameterFactory = this.getParamFactory("moduleID", Integer.class);
        this.sectionIDQueryParameterFactory = this.getParamFactory("sectionID", Integer.class);
    }

    @Override
    public void add(SimpleBackgroundModuleDescriptor moduleDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = this.createTransaction();
            this.add(moduleDescriptor, transactionHandler, null);
            ((MySQLModuleSettingDAO)this.moduleSettingDAO).set(moduleDescriptor, transactionHandler);
            this.moduleAttributeDAO.set(moduleDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        finally {
            TransactionHandler.autoClose((TransactionHandler)transactionHandler);
        }
    }

    @Override
    public void update(SimpleBackgroundModuleDescriptor moduleDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = this.createTransaction();
            this.update(moduleDescriptor, transactionHandler, null);
            ((MySQLModuleSettingDAO)this.moduleSettingDAO).set(moduleDescriptor, transactionHandler);
            this.moduleAttributeDAO.set(moduleDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        finally {
            TransactionHandler.autoClose((TransactionHandler)transactionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleBackgroundModuleDescriptor> getEnabledModules(Integer sectionID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            HighLevelQuery query = new HighLevelQuery();
            query.addParameter(this.enabledQueryParameterFactory.getParameter((Object)true));
            query.addParameter(this.sectionIDQueryParameterFactory.getParameter((Object)sectionID));
            List modules = this.getAll(query, connection);
            if (modules != null) {
                this.getRelations(modules, connection);
            }
            List list = modules;
            return list;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleBackgroundModuleDescriptor> getModules(Integer sectionID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            HighLevelQuery query = new HighLevelQuery();
            query.addParameter(this.sectionIDQueryParameterFactory.getParameter((Object)sectionID));
            List modules = this.getAll(query, connection);
            if (modules != null) {
                this.getRelations(modules, connection);
            }
            List list = modules;
            return list;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleBackgroundModuleDescriptor getModule(Integer moduleID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            HighLevelQuery query = new HighLevelQuery();
            query.addParameter(this.moduleIDQueryParameterFactory.getParameter((Object)moduleID));
            SimpleBackgroundModuleDescriptor moduleDescriptor = (SimpleBackgroundModuleDescriptor)this.get(query, connection);
            if (moduleDescriptor != null) {
                this.getRelations(Collections.singletonList(moduleDescriptor), connection);
            }
            SimpleBackgroundModuleDescriptor simpleBackgroundModuleDescriptor = moduleDescriptor;
            return simpleBackgroundModuleDescriptor;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    protected void getRelations(List<SimpleBackgroundModuleDescriptor> modules, Connection connection) throws SQLException {
        for (SimpleBackgroundModuleDescriptor moduleDescriptor : modules) {
            ((MySQLModuleSettingDAO)this.moduleSettingDAO).getSettingsHandler(moduleDescriptor, connection);
            this.moduleAttributeDAO.getAttributeHandler(moduleDescriptor, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleBackgroundModuleDescriptor> getModulesByAttribute(String name, String value) throws SQLException {
        List<Integer> moduleIDs = this.moduleAttributeDAO.getModulesIDsByAttribute(name, value);
        if (moduleIDs == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            HighLevelQuery query = new HighLevelQuery();
            query.addParameter(this.moduleIDQueryParameterFactory.getWhereInParameter(moduleIDs));
            List moduleDescriptors = this.getAll(query, connection);
            if (moduleDescriptors != null) {
                this.getRelations(moduleDescriptors, connection);
            }
            List list = moduleDescriptors;
            return list;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }
}

