/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.SimpleCachedXSLTDescriptor;
import se.unlogic.hierarchy.core.interfaces.CachedXSLTDescriptor;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.i18n.Language;
import se.unlogic.standardutils.xsl.XSLTransformer;

public class XSLCacheHandler {
    protected Logger log = Logger.getLogger(this.getClass());
    protected final ConcurrentHashMap<Language, HashSet<SimpleCachedXSLTDescriptor>> languageMap = new ConcurrentHashMap();
    protected SimpleCachedXSLTDescriptor defaultXsltDescriptor;
    protected Language defaultLanguage;
    protected int xslDescriptorCount;

    public XSLCacheHandler(Language defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public synchronized CachedXSLTDescriptor add(XSLTransformer cachedXSLT, Language language, String name, boolean isDefault, boolean useFullMenu) {
        SimpleCachedXSLTDescriptor xsltDescriptor = new SimpleCachedXSLTDescriptor(cachedXSLT, language, name, isDefault, useFullMenu);
        HashSet<SimpleCachedXSLTDescriptor> languageDesigns = this.languageMap.get(language);
        if (languageDesigns == null) {
            languageDesigns = new HashSet();
            languageDesigns.add(xsltDescriptor);
            this.languageMap.put(language, languageDesigns);
            if (isDefault && language.equals((Object)this.defaultLanguage)) {
                this.defaultXsltDescriptor = xsltDescriptor;
            }
            ++this.xslDescriptorCount;
        } else {
            languageDesigns = new HashSet<SimpleCachedXSLTDescriptor>(languageDesigns);
            if (isDefault) {
                for (SimpleCachedXSLTDescriptor cachedXSLTDescriptor : languageDesigns) {
                    if (!cachedXSLTDescriptor.isDefault()) continue;
                    cachedXSLTDescriptor.setDefault(false);
                }
                if (language.equals((Object)this.defaultLanguage)) {
                    this.defaultXsltDescriptor = xsltDescriptor;
                }
            }
            if (!languageDesigns.add(xsltDescriptor)) {
                languageDesigns.remove(xsltDescriptor);
                languageDesigns.add(xsltDescriptor);
            } else {
                ++this.xslDescriptorCount;
            }
            this.languageMap.put(language, languageDesigns);
        }
        return xsltDescriptor;
    }

    public synchronized void remove(CachedXSLTDescriptor xsltDescriptor) {
        HashSet<SimpleCachedXSLTDescriptor> languageDesigns = this.languageMap.get(xsltDescriptor.getLanguage());
        if (languageDesigns != null && languageDesigns.contains(xsltDescriptor)) {
            languageDesigns = new HashSet<SimpleCachedXSLTDescriptor>(languageDesigns);
            languageDesigns.remove(xsltDescriptor);
            if (xsltDescriptor.equals(this.defaultXsltDescriptor)) {
                this.defaultXsltDescriptor = null;
            }
            this.languageMap.put(xsltDescriptor.getLanguage(), languageDesigns);
            --this.xslDescriptorCount;
        }
    }

    public CachedXSLTDescriptor getCachedXSLTDescriptor(String name) {
        return this.getCachedXSLTDescriptor(this.defaultLanguage, name);
    }

    public CachedXSLTDescriptor getCachedXSLTDescriptor(Language language) {
        if (language.equals((Object)this.defaultLanguage)) {
            return this.getCachedXSLTDescriptor();
        }
        HashSet<SimpleCachedXSLTDescriptor> languageDesigns = this.languageMap.get(this.defaultLanguage);
        for (CachedXSLTDescriptor cachedXSLTDescriptor : languageDesigns) {
            if (!cachedXSLTDescriptor.isDefault()) continue;
            return cachedXSLTDescriptor;
        }
        return null;
    }

    public CachedXSLTDescriptor getCachedXSLTDescriptor() {
        return this.defaultXsltDescriptor;
    }

    public CachedXSLTDescriptor getCachedXSLTDescriptor(Language language, String name) {
        HashSet<SimpleCachedXSLTDescriptor> languageDesigns = this.languageMap.get(language);
        for (CachedXSLTDescriptor cachedXSLTDescriptor : languageDesigns) {
            if (!cachedXSLTDescriptor.getName().equals(name)) continue;
            return cachedXSLTDescriptor;
        }
        return null;
    }

    public Collection<CachedXSLTDescriptor> getCachedXSLTDescriptors(Language language) {
        ArrayList<CachedXSLTDescriptor> cachedXSLTDescriptors = new ArrayList<CachedXSLTDescriptor>(this.languageMap.size());
        HashSet<SimpleCachedXSLTDescriptor> languageDesigns = this.languageMap.get(language);
        for (CachedXSLTDescriptor cachedXSLTDescriptor : languageDesigns) {
            cachedXSLTDescriptors.add(cachedXSLTDescriptor);
        }
        return cachedXSLTDescriptors;
    }

    public CachedXSLTDescriptor getBestMatchingXSLTDescriptor(Language language, String name) {
        CachedXSLTDescriptor xsltDescriptor;
        if (this.defaultXsltDescriptor != null && this.xslDescriptorCount == 1) {
            return this.defaultXsltDescriptor;
        }
        if (language != null) {
            if (name != null && (xsltDescriptor = this.getCachedXSLTDescriptor(language, name)) != null) {
                return xsltDescriptor;
            }
            xsltDescriptor = this.getCachedXSLTDescriptor(language);
            if (xsltDescriptor != null) {
                return xsltDescriptor;
            }
        }
        if (name != null && (xsltDescriptor = this.getCachedXSLTDescriptor(name)) != null) {
            return xsltDescriptor;
        }
        return this.getCachedXSLTDescriptor();
    }

    public int getXslDescriptorCount() {
        return this.xslDescriptorCount;
    }

    public List<? extends Map.Entry<CachedXSLTDescriptor, ? extends Exception>> reloadStylesheets() {
        ArrayList<SimpleEntry> errorList = new ArrayList<SimpleEntry>();
        for (Set set : this.languageMap.values()) {
            for (SimpleCachedXSLTDescriptor descriptor : set) {
                try {
                    descriptor.getCachedXSLT().reloadStyleSheet();
                }
                catch (TransformerConfigurationException e) {
                    this.handleReloadingException(descriptor, e);
                    errorList.add(new SimpleEntry((Object)descriptor, (Object)e));
                }
                catch (RuntimeException e) {
                    this.handleReloadingException(descriptor, e);
                    errorList.add(new SimpleEntry((Object)descriptor, (Object)e));
                }
            }
        }
        if (!errorList.isEmpty()) {
            return errorList;
        }
        return null;
    }

    private void handleReloadingException(SimpleCachedXSLTDescriptor descriptor, Exception e) {
        this.log.error((Object)("Error reloading stylesheet " + descriptor));
    }

    public CachedXSLTDescriptor getDefaultXsltDescriptor() {
        return this.defaultXsltDescriptor;
    }
}

