/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import se.unlogic.hierarchy.core.beans.AliasMapping;
import se.unlogic.hierarchy.core.beans.ModuleMapping;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.cache.BaseModuleCache;
import se.unlogic.hierarchy.core.cache.ModulePriorityComparator;
import se.unlogic.hierarchy.core.enums.AliasType;
import se.unlogic.hierarchy.core.exceptions.InvalidModuleNameException;
import se.unlogic.hierarchy.core.interfaces.Module;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MultipleAliasModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.string.StringUtils;

public abstract class WildcardModuleCache<DescriptorType extends MultipleAliasModuleDescriptor, ModuleType extends Module<?>, ListenerType>
extends BaseModuleCache<DescriptorType, ModuleType, ListenerType> {
    public static final ModulePriorityComparator PRIORITY_COMPARATOR = new ModulePriorityComparator();
    public static final String EXCLUDE_ALIAS_PREFIX = "exclude:";
    public static final String REGEXP_ALIAS_PREFIX = "regexp:";
    protected final ArrayList<ModuleMapping<DescriptorType>> mappingList = new ArrayList();

    public WildcardModuleCache(SystemInterface systemInterface) {
        super(systemInterface);
    }

    protected void setAliasMappings(DescriptorType moduleDescriptor) {
        ArrayList<AliasMapping> aliasMappingList = new ArrayList<AliasMapping>();
        for (String alias : moduleDescriptor.getAliases()) {
            boolean exclude = false;
            if (alias.toLowerCase().startsWith(REGEXP_ALIAS_PREFIX)) {
                aliasMappingList.add(new AliasMapping(alias.replaceAll("/\\/", "\\").replace(REGEXP_ALIAS_PREFIX, ""), AliasType.REGEXP));
                continue;
            }
            if (alias.toLowerCase().startsWith(EXCLUDE_ALIAS_PREFIX) && alias.length() > EXCLUDE_ALIAS_PREFIX.length()) {
                alias = alias.substring(EXCLUDE_ALIAS_PREFIX.length());
                exclude = true;
            }
            if (!alias.contains("*")) {
                aliasMappingList.add(new AliasMapping(alias, AliasType.WHEN_REQUEST_EQUALS, exclude));
                continue;
            }
            if (alias.equals("*") || alias.equals("**")) {
                aliasMappingList.add(new AliasMapping(null, AliasType.ALWAYS, exclude));
                continue;
            }
            if (alias.startsWith("*") && alias.endsWith("*") && alias.length() > 2) {
                aliasMappingList.add(new AliasMapping(alias.substring(1, alias.length() - 1), AliasType.WHEN_REQUEST_CONTAINS, exclude));
                continue;
            }
            if (alias.startsWith("*")) {
                aliasMappingList.add(new AliasMapping(alias.substring(1), AliasType.WHEN_REQUEST_ENDS_WITH, exclude));
                continue;
            }
            if (alias.endsWith("*")) {
                aliasMappingList.add(new AliasMapping(alias.substring(0, alias.length() - 1), AliasType.WHEN_REQUEST_STARTS_WITH, exclude));
                continue;
            }
            this.log.warn((Object)("Unsupported alias detected for module " + moduleDescriptor));
        }
        this.mappingList.add(new ModuleMapping<DescriptorType>(moduleDescriptor, aliasMappingList));
        Collections.sort(this.mappingList, PRIORITY_COMPARATOR);
    }

    protected void removeAliasMappings(DescriptorType moduleDescriptor) {
        for (ModuleMapping<DescriptorType> moduleMapping : this.mappingList) {
            if (!((MultipleAliasModuleDescriptor)moduleMapping.getModuleDescriptor()).equals(moduleDescriptor)) continue;
            this.mappingList.remove(moduleMapping);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map.Entry<DescriptorType, ModuleType>> getEntries(String currentURI, User user) {
        this.r.lock();
        ArrayList<Map.Entry<DescriptorType, ModuleType>> matches = new ArrayList<Map.Entry<DescriptorType, ModuleType>>();
        try {
            block11: for (ModuleMapping<DescriptorType> moduleMapping : this.mappingList) {
                if (!AccessUtils.checkAccess(user, moduleMapping.getModuleDescriptor())) continue;
                for (AliasMapping aliasMapping : moduleMapping.getMappings()) {
                    switch (aliasMapping.getAliasType()) {
                        case ALWAYS: {
                            if (aliasMapping.isExclude()) continue block11;
                            matches.add(this.getEntry(moduleMapping));
                            continue block11;
                        }
                        case WHEN_REQUEST_STARTS_WITH: {
                            if (!currentURI.startsWith(aliasMapping.getAlias())) break;
                            if (aliasMapping.isExclude()) continue block11;
                            matches.add(this.getEntry(moduleMapping));
                            continue block11;
                        }
                        case WHEN_REQUEST_ENDS_WITH: {
                            if (!currentURI.endsWith(aliasMapping.getAlias())) break;
                            if (aliasMapping.isExclude()) continue block11;
                            matches.add(this.getEntry(moduleMapping));
                            continue block11;
                        }
                        case WHEN_REQUEST_CONTAINS: {
                            if (!currentURI.contains(aliasMapping.getAlias())) break;
                            if (aliasMapping.isExclude()) continue block11;
                            matches.add(this.getEntry(moduleMapping));
                            continue block11;
                        }
                        case WHEN_REQUEST_EQUALS: {
                            if (!currentURI.equals(aliasMapping.getAlias())) break;
                            if (aliasMapping.isExclude()) continue block11;
                            matches.add(this.getEntry(moduleMapping));
                            continue block11;
                        }
                        case REGEXP: {
                            if (!aliasMapping.getPattern().matcher(currentURI).matches()) break;
                            matches.add(this.getEntry(moduleMapping));
                            continue block11;
                        }
                    }
                }
            }
            if (!matches.isEmpty()) {
                ArrayList<Map.Entry<DescriptorType, ModuleType>> arrayList = matches;
                return arrayList;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    private Map.Entry<DescriptorType, ModuleType> getEntry(ModuleMapping<DescriptorType> moduleMapping) {
        return new SimpleEntry(moduleMapping.getModuleDescriptor(), this.instanceMap.get(moduleMapping.getModuleDescriptor()));
    }

    protected void validateDescritor(DescriptorType descriptor) throws InvalidModuleNameException {
        if (StringUtils.isEmpty((String)descriptor.getName())) {
            throw new InvalidModuleNameException((ModuleDescriptor)descriptor);
        }
    }
}

