/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.daos.interfaces.SectionDAO;
import se.unlogic.hierarchy.core.interfaces.FullSectionInterface;
import se.unlogic.hierarchy.core.interfaces.SectionCacheListener;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.sections.Section;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.collections.StrictHashMap;
import se.unlogic.standardutils.datatypes.SimpleEntry;

public class SectionCache {
    private final Logger log = Logger.getLogger(this.getClass());
    private final FullSectionInterface sectionInterface;
    private final SectionDAO sectionDAO;
    private final StrictHashMap<SectionDescriptor, Section> sectionInstanceMap = new StrictHashMap();
    private final ArrayList<SectionCacheListener> cacheListeners = new ArrayList();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public SectionCache(FullSectionInterface sectionInterface) {
        this.sectionInterface = sectionInterface;
        this.sectionDAO = sectionInterface.getSystemInterface().getCoreDaoFactory().getSectionDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheSections() throws KeyNotCachedException, KeyAlreadyCachedException, SQLException {
        this.w.lock();
        try {
            ArrayList<SimpleSectionDescriptor> sectionBeanList = this.sectionDAO.getEnabledSubSections(this.sectionInterface.getSectionDescriptor(), false);
            if (sectionBeanList != null && sectionBeanList.size() > 0) {
                this.log.debug((Object)("Checking section cache for subsections to unload in section " + this.sectionInterface.getSectionDescriptor() + "..."));
                if (!this.sectionInstanceMap.isEmpty()) {
                    ArrayList keys = new ArrayList(this.sectionInstanceMap.keySet());
                    for (SectionDescriptor sectionDescriptor : keys) {
                        if (sectionBeanList.contains(sectionDescriptor)) continue;
                        this.log.info((Object)("Subsection" + sectionDescriptor + " not found in new subsection list for section " + this.sectionInterface.getSectionDescriptor() + ", removing from cache..."));
                        this.unload(sectionDescriptor);
                    }
                    this.log.debug((Object)("Finished checking cache for subsections to unload in section " + this.sectionInterface.getSectionDescriptor()));
                } else {
                    this.log.debug((Object)("Cache is empty, no subsections to unload in section " + this.sectionInterface.getSectionDescriptor()));
                }
                this.log.debug((Object)("Adding new subsections to cache and refreshing cached subsections for section " + this.sectionInterface.getSectionDescriptor() + "..."));
                for (SimpleSectionDescriptor simpleSectionDescriptor : sectionBeanList) {
                    if (this.sectionInstanceMap.containsKey((Object)simpleSectionDescriptor)) {
                        this.update(simpleSectionDescriptor);
                        continue;
                    }
                    this.log.info((Object)("Adding subsection " + simpleSectionDescriptor + " to cache for section " + this.sectionInterface.getSectionDescriptor() + "..."));
                    try {
                        this.cache(simpleSectionDescriptor);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Error caching new instance of subsection " + simpleSectionDescriptor + " for section " + this.sectionInterface.getSectionDescriptor()), (Throwable)e);
                    }
                }
                this.log.debug((Object)("Finished adding new subsections and updating cached subsections in section " + this.sectionInterface.getSectionDescriptor()));
            } else {
                this.log.debug((Object)("No subsections found in database, for section " + this.sectionInterface.getSectionDescriptor()));
                this.unload();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public SectionInterface cache(SimpleSectionDescriptor simpleSectionDescriptor) {
        this.w.lock();
        try {
            Section sectionInstance = new Section(simpleSectionDescriptor, this.sectionInterface, this.sectionInterface.getSystemInterface());
            this.sectionInstanceMap.put((Object)simpleSectionDescriptor, (Object)sectionInstance);
            for (SectionCacheListener cl : this.cacheListeners) {
                cl.sectionCached(simpleSectionDescriptor, sectionInstance);
            }
            sectionInstance.cacheModuleAndSections();
            this.log.debug((Object)("Subsection" + simpleSectionDescriptor + " added to section cache of section " + this.sectionInterface.getSectionDescriptor()));
            Section section = sectionInstance;
            return section;
        }
        catch (KeyAlreadyCachedException e) {
            throw e;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SectionDescriptor sectionDescriptor) throws KeyNotCachedException {
        block5: {
            this.w.lock();
            try {
                Section sectionInstance = (Section)this.sectionInstanceMap.get((Object)sectionDescriptor);
                if (sectionInstance != null) {
                    sectionInstance.update(sectionDescriptor);
                    this.sectionInstanceMap.update((Object)sectionDescriptor, (Object)sectionInstance);
                    for (SectionCacheListener cl : this.cacheListeners) {
                        cl.sectionUpdated(sectionDescriptor, sectionInstance);
                    }
                    break block5;
                }
                throw new KeyNotCachedException((Object)sectionDescriptor);
            }
            finally {
                this.w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(SectionDescriptor sectionDescriptor) throws KeyNotCachedException {
        this.w.lock();
        try {
            Section sectionInstance = (Section)this.sectionInstanceMap.get((Object)sectionDescriptor);
            this.sectionInstanceMap.remove((Object)sectionDescriptor);
            for (SectionCacheListener cl : this.cacheListeners) {
                cl.sectionUnloaded(sectionDescriptor, sectionInstance);
            }
            sectionInstance.unload();
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        this.w.lock();
        try {
            ArrayList sectionList = new ArrayList(this.sectionInstanceMap.keySet());
            for (SectionDescriptor sectionDescriptor : sectionList) {
                try {
                    this.unload(sectionDescriptor);
                }
                catch (KeyNotCachedException e) {
                    this.log.error((Object)("Error unloading subsection " + sectionDescriptor + " from subsection cache for section " + this.sectionInterface.getSectionDescriptor() + ", " + (Object)((Object)e)));
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public Section getSectionInstance(SectionDescriptor sectionDescriptor) {
        this.r.lock();
        try {
            Section section = (Section)this.sectionInstanceMap.get((Object)sectionDescriptor);
            return section;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isWriteLocked() {
        return this.rwl.isWriteLocked();
    }

    public int size() {
        this.r.lock();
        try {
            int n = this.sectionInstanceMap.size();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isCached(SimpleSectionDescriptor simpleSectionDescriptor) {
        this.r.lock();
        try {
            boolean bl = this.sectionInstanceMap.containsKey((Object)simpleSectionDescriptor);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public ArrayList<SectionCacheListener> getCacheListeners() {
        this.r.lock();
        try {
            ArrayList arrayList = (ArrayList)this.cacheListeners.clone();
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    public void addCacheListener(SectionCacheListener cacheListener) {
        this.w.lock();
        try {
            this.cacheListeners.add(cacheListener);
        }
        finally {
            this.w.unlock();
        }
    }

    public void removeCacheListener(SectionCacheListener cacheListener) {
        this.w.lock();
        try {
            this.cacheListeners.remove(cacheListener);
        }
        finally {
            this.w.unlock();
        }
    }

    public ArrayList<SectionDescriptor> getCachedSections() {
        return new ArrayList<SectionDescriptor>(this.sectionInstanceMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<SectionDescriptor, Section> getEntry(String alias) {
        this.r.lock();
        try {
            for (Map.Entry cacheEntry : this.sectionInstanceMap.entrySet()) {
                if (!((SectionDescriptor)cacheEntry.getKey()).getAlias().equals(alias)) continue;
                SimpleEntry simpleEntry = new SimpleEntry(cacheEntry);
                return simpleEntry;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<SectionDescriptor, Section> getEntry(Integer sectionID) {
        this.r.lock();
        try {
            for (Map.Entry cacheEntry : this.sectionInstanceMap.entrySet()) {
                if (!sectionID.equals(((SectionDescriptor)cacheEntry.getKey()).getSectionID())) continue;
                SimpleEntry simpleEntry = new SimpleEntry(cacheEntry);
                return simpleEntry;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    public Map<SectionDescriptor, Section> getSectionMap() {
        this.r.lock();
        try {
            HashMap<SectionDescriptor, Section> map = new HashMap<SectionDescriptor, Section>(this.sectionInstanceMap.size());
            map.putAll((Map<SectionDescriptor, Section>)this.sectionInstanceMap);
            HashMap<SectionDescriptor, Section> hashMap = map;
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    public List<Section> getSections() {
        this.r.lock();
        try {
            ArrayList<Section> arrayList = new ArrayList<Section>(this.sectionInstanceMap.values());
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }
}

