/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.Bundle;
import se.unlogic.hierarchy.core.beans.MenuItem;
import se.unlogic.hierarchy.core.beans.ModuleMenuItem;
import se.unlogic.hierarchy.core.beans.SectionMenu;
import se.unlogic.hierarchy.core.beans.SectionMenuItem;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.beans.VirtualMenuItem;
import se.unlogic.hierarchy.core.cache.MenuItemComparator;
import se.unlogic.hierarchy.core.daos.factories.CoreDaoFactory;
import se.unlogic.hierarchy.core.daos.interfaces.MenuIndexDAO;
import se.unlogic.hierarchy.core.daos.interfaces.VirtualMenuItemDAO;
import se.unlogic.hierarchy.core.enums.MenuItemType;
import se.unlogic.hierarchy.core.enums.URLType;
import se.unlogic.hierarchy.core.interfaces.BundleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MenuItemDescriptor;
import se.unlogic.hierarchy.core.interfaces.MenuSorter;
import se.unlogic.hierarchy.core.interfaces.SectionCacheListener;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.sections.Section;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.webutils.http.URIParser;

public class MenuItemCache
implements ForegroundModuleCacheListener,
SectionCacheListener {
    private static final MenuItemComparator COMPARATOR = new MenuItemComparator();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final HashMap<ForegroundModuleDescriptor, List<ModuleMenuItem>> moduleMenuItemMap = new HashMap();
    private final HashMap<ForegroundModuleDescriptor, List<Bundle>> bundleMenuItemMap = new HashMap();
    private final HashMap<SectionDescriptor, SectionMenuItem> sectionMenuItemMap = new HashMap();
    private final ArrayList<VirtualMenuItem> virtualMenuItems = new ArrayList();
    private final TreeSet<MenuItem> menuItemSet = new TreeSet<MenuItem>(COMPARATOR);
    private final MenuIndexDAO menuIndexDAO;
    private final VirtualMenuItemDAO virtualMenuItemDAO;
    private final Logger log = Logger.getLogger(this.getClass());
    private SectionDescriptor sectionDescriptor;

    public MenuItemCache(CoreDaoFactory coreDaoFactory, SectionDescriptor sectionDesciptor) {
        this.menuIndexDAO = coreDaoFactory.getMenuIndexDAO();
        this.virtualMenuItemDAO = coreDaoFactory.getVirtualMenuItemDAO();
        this.sectionDescriptor = sectionDesciptor;
        try {
            this.cacheVirtualMenuItems();
        }
        catch (SQLException e) {
            this.log.error((Object)("Error caching virtual menuitems for section " + sectionDesciptor));
        }
    }

    public void setSectionDescriptor(SectionDescriptor sectionDesciptor) {
        try {
            this.w.lock();
            this.sectionDescriptor = sectionDesciptor;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheVirtualMenuItems() throws SQLException {
        try {
            ArrayList<VirtualMenuItem> virtualMenuItems;
            this.w.lock();
            if (!this.virtualMenuItems.isEmpty()) {
                this.menuItemSet.removeAll(this.virtualMenuItems);
                this.virtualMenuItems.clear();
            }
            if ((virtualMenuItems = this.virtualMenuItemDAO.getMenuItemsInSection(this.sectionDescriptor.getSectionID())) != null) {
                for (VirtualMenuItem virtualMenuItem : virtualMenuItems) {
                    this.log.debug((Object)("Adding to virtual menuitem " + virtualMenuItem + " to menuitem cache for section " + this.sectionDescriptor));
                    virtualMenuItem.setUrlType(URLType.FULL);
                    virtualMenuItem.setSectionID(this.sectionDescriptor.getSectionID());
                    this.virtualMenuItems.add(virtualMenuItem);
                }
                if (!this.virtualMenuItems.isEmpty()) {
                    this.menuIndexDAO.populateVirtualMenuIndex(this.virtualMenuItems);
                    this.menuItemSet.addAll(this.virtualMenuItems);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void rebuildIndex() {
        this.w.lock();
        try {
            this.log.debug((Object)("Rebuilding menu index for menucache for section " + this.sectionDescriptor));
            this.menuItemSet.clear();
            for (List<ModuleMenuItem> list : this.moduleMenuItemMap.values()) {
                this.menuItemSet.addAll(list);
            }
            this.menuItemSet.addAll(this.sectionMenuItemMap.values());
            this.menuItemSet.addAll(this.virtualMenuItems);
            for (List<MenuItem> list : this.bundleMenuItemMap.values()) {
                this.menuItemSet.addAll(list);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void saveIndex() {
        this.w.lock();
        try {
            this.menuIndexDAO.updateMenuIndex(this.menuItemSet);
        }
        catch (SQLException e) {
            this.log.error((Object)("Error " + e + " saveing menuindex."));
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleCached(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        this.w.lock();
        try {
            if (moduleDescriptor.isVisibleInMenu()) {
                List<? extends BundleDescriptor> bundleDescriptors;
                List<? extends MenuItemDescriptor> menuItems = moduleInstance.getVisibleMenuItems();
                if (menuItems != null) {
                    ArrayList<ModuleMenuItem> moduleMenuItems = new ArrayList<ModuleMenuItem>();
                    for (MenuItemDescriptor menuItemDescriptor : menuItems) {
                        if (!this.validate(menuItemDescriptor, moduleDescriptor, null)) continue;
                        ModuleMenuItem moduleMenuItem = new ModuleMenuItem(menuItemDescriptor, moduleDescriptor, false);
                        moduleMenuItems.add(moduleMenuItem);
                    }
                    this.menuIndexDAO.populateModuleMenuIndex(moduleMenuItems);
                    this.moduleMenuItemMap.put(moduleDescriptor, moduleMenuItems);
                    this.menuItemSet.addAll(moduleMenuItems);
                }
                if ((bundleDescriptors = moduleInstance.getVisibleBundles()) != null) {
                    ArrayList<Bundle> bundles = new ArrayList<Bundle>();
                    for (BundleDescriptor bundleDescriptor : bundleDescriptors) {
                        if (!this.validate(bundleDescriptor, moduleDescriptor)) continue;
                        Bundle b = new Bundle(bundleDescriptor, moduleDescriptor);
                        bundles.add(b);
                    }
                    this.menuIndexDAO.populateBundleMenuIndex(bundles);
                    this.bundleMenuItemMap.put(moduleDescriptor, bundles);
                    this.menuItemSet.addAll(bundles);
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)("Error " + e + " getting menuIndex for menuitems from module " + moduleDescriptor));
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void moduleUnloaded(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        this.w.lock();
        try {
            if (this.moduleMenuItemMap.containsKey(moduleDescriptor)) {
                this.menuItemSet.removeAll((Collection)this.moduleMenuItemMap.get(moduleDescriptor));
                this.moduleMenuItemMap.remove(moduleDescriptor);
            }
            if (this.bundleMenuItemMap.containsKey(moduleDescriptor)) {
                this.menuItemSet.removeAll((Collection)this.bundleMenuItemMap.get(moduleDescriptor));
                this.bundleMenuItemMap.remove(moduleDescriptor);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleUpdated(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        this.w.lock();
        try {
            if (moduleDescriptor.isVisibleInMenu()) {
                List<? extends BundleDescriptor> bundleDescriptors;
                List<? extends MenuItemDescriptor> menuItems = moduleInstance.getVisibleMenuItems();
                List<ModuleMenuItem> oldMenuItems = this.moduleMenuItemMap.get(moduleDescriptor);
                if (oldMenuItems != null) {
                    this.menuItemSet.removeAll(oldMenuItems);
                }
                if (menuItems == null || menuItems.isEmpty()) {
                    this.moduleMenuItemMap.remove(moduleDescriptor);
                } else {
                    ArrayList<ModuleMenuItem> moduleMenuItems = new ArrayList<ModuleMenuItem>();
                    for (MenuItemDescriptor menuItemDescriptor : menuItems) {
                        if (!this.validate(menuItemDescriptor, moduleDescriptor, null)) continue;
                        ModuleMenuItem m = new ModuleMenuItem(menuItemDescriptor, moduleDescriptor, false);
                        moduleMenuItems.add(m);
                    }
                    this.menuIndexDAO.populateModuleMenuIndex(moduleMenuItems);
                    this.moduleMenuItemMap.put(moduleDescriptor, moduleMenuItems);
                    this.menuItemSet.addAll(moduleMenuItems);
                }
                List<Bundle> oldBundles = this.bundleMenuItemMap.get(moduleDescriptor);
                if (oldBundles != null) {
                    this.menuItemSet.removeAll(oldBundles);
                }
                if ((bundleDescriptors = moduleInstance.getVisibleBundles()) == null || bundleDescriptors.isEmpty()) {
                    this.bundleMenuItemMap.remove(moduleDescriptor);
                } else {
                    ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                    for (BundleDescriptor bundleDescriptor : bundleDescriptors) {
                        if (!this.validate(bundleDescriptor, moduleDescriptor)) continue;
                        Bundle b = new Bundle(bundleDescriptor, moduleDescriptor);
                        arrayList.add(b);
                    }
                    this.menuIndexDAO.populateBundleMenuIndex(arrayList);
                    this.bundleMenuItemMap.put(moduleDescriptor, arrayList);
                    this.menuItemSet.addAll(arrayList);
                }
            } else {
                if (this.moduleMenuItemMap.containsKey(moduleDescriptor)) {
                    this.menuItemSet.removeAll((Collection)this.moduleMenuItemMap.get(moduleDescriptor));
                    this.moduleMenuItemMap.remove(moduleDescriptor);
                }
                if (this.bundleMenuItemMap.containsKey(moduleDescriptor)) {
                    this.menuItemSet.removeAll((Collection)this.bundleMenuItemMap.get(moduleDescriptor));
                    this.bundleMenuItemMap.remove(moduleDescriptor);
                }
            }
        }
        catch (SQLException e) {
            this.log.error((Object)("Error " + e + " getting menuIndex for menuitems from module " + moduleDescriptor));
        }
        finally {
            this.w.unlock();
        }
    }

    private boolean validate(BundleDescriptor bundleDescriptor, ForegroundModuleDescriptor moduleDescriptor) {
        if (StringUtils.isEmpty((String)bundleDescriptor.getName())) {
            this.log.warn((Object)("Received bundle descriptor with no name set from module " + moduleDescriptor + ", ignoring bundle."));
            return false;
        }
        if (StringUtils.isEmpty((String)bundleDescriptor.getDescription())) {
            this.log.warn((Object)("Received bundle descriptor with no description set from module " + moduleDescriptor + ", ignoring bundle."));
            return false;
        }
        if (StringUtils.isEmpty((String)bundleDescriptor.getUniqueID())) {
            this.log.warn((Object)("Received bundle descriptor with no unique ID set from module " + moduleDescriptor + ", ignoring bundle."));
            return false;
        }
        if (bundleDescriptor.getItemType() == null) {
            this.log.warn((Object)("Received bundle descriptor with no item type set from module " + moduleDescriptor + ", ignoring bundle."));
            return false;
        }
        if (bundleDescriptor.getItemType() != MenuItemType.BLANK && bundleDescriptor.getItemType() != MenuItemType.TITLE && StringUtils.isEmpty((String)bundleDescriptor.getUrl())) {
            this.log.warn((Object)("Received bundle descriptor with item type " + (Object)((Object)bundleDescriptor.getItemType()) + " but no url set from module " + moduleDescriptor + ", ignoring bundle."));
            return false;
        }
        if (bundleDescriptor.getMenuItemDescriptors() != null) {
            for (MenuItemDescriptor menuItemDescriptor : bundleDescriptor.getMenuItemDescriptors()) {
                if (this.validate(menuItemDescriptor, moduleDescriptor, bundleDescriptor)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validate(MenuItemDescriptor menuItemDescriptor, ForegroundModuleDescriptor moduleDescriptor, BundleDescriptor bundleDescriptor) {
        String ignoreString = "menuitem";
        if (moduleDescriptor.getModuleID() == null && menuItemDescriptor.getModuleID() == null) {
            this.log.warn((Object)("Received menuitem descriptor with no moduleID set from virtual module " + moduleDescriptor + ", ignoring " + ignoreString + "."));
            return false;
        }
        String bundleString = "";
        if (bundleDescriptor != null) {
            bundleString = " in bundle " + bundleDescriptor.getName();
            ignoreString = "bundle";
        }
        if (StringUtils.isEmpty((String)menuItemDescriptor.getName())) {
            this.log.warn((Object)("Received menuitem descriptor with no name set from module " + moduleDescriptor + bundleString + ", ignoring " + ignoreString + "."));
            return false;
        }
        if (StringUtils.isEmpty((String)menuItemDescriptor.getDescription())) {
            this.log.warn((Object)("Received menuitem descriptor with no description set from module " + moduleDescriptor + bundleString + ", ignoring " + ignoreString + "."));
            return false;
        }
        if (bundleDescriptor == null && StringUtils.isEmpty((String)menuItemDescriptor.getUniqueID())) {
            this.log.warn((Object)("Received menuitem descriptor with no unique ID set from module " + moduleDescriptor + bundleString + ", ignoring " + ignoreString + "."));
            return false;
        }
        if (menuItemDescriptor.getItemType() == null) {
            this.log.warn((Object)("Received menuitem descriptor with no item type set from module " + moduleDescriptor + bundleString + ", ignoring " + ignoreString + "."));
            return false;
        }
        if (menuItemDescriptor.getItemType() != MenuItemType.BLANK && menuItemDescriptor.getItemType() != MenuItemType.TITLE && StringUtils.isEmpty((String)menuItemDescriptor.getUrl())) {
            this.log.warn((Object)("Received menuitem descriptor with item type " + (Object)((Object)menuItemDescriptor.getItemType()) + " but no url set from module " + moduleDescriptor + bundleString + ", ignoring " + ignoreString + "."));
            return false;
        }
        return true;
    }

    public void clearModules() {
        this.w.lock();
        try {
            this.log.debug((Object)("Removing all module menuitems from menuitem cache for section " + this.sectionDescriptor));
            if (this.moduleMenuItemMap.size() > 0) {
                for (List<ModuleMenuItem> menuItemList : this.moduleMenuItemMap.values()) {
                    this.menuItemSet.removeAll(menuItemList);
                }
                this.moduleMenuItemMap.clear();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public int size() {
        return this.moduleMenuItemMap.size();
    }

    public String toString() {
        return this.moduleMenuItemMap.toString();
    }

    public HashMap<ForegroundModuleDescriptor, ArrayList<MenuItem>> getModuleMenuItemMap() {
        this.r.lock();
        try {
            HashMap hashMap = (HashMap)this.moduleMenuItemMap.clone();
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    public TreeSet<MenuItem> getMenuItemSet() {
        this.r.lock();
        try {
            TreeSet treeSet = (TreeSet)this.menuItemSet.clone();
            return treeSet;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sectionCached(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyAlreadyCachedException {
        this.w.lock();
        try {
            if (sectionDescriptor.isVisibleInMenu()) {
                this.log.debug((Object)("Adding to section " + sectionDescriptor + " to menuitem cache for section " + this.sectionDescriptor));
                SectionMenuItem menuItem = this.createMenuItem(sectionDescriptor);
                this.menuIndexDAO.populateSectionMenuIndex(menuItem);
                this.sectionMenuItemMap.put(sectionDescriptor, menuItem);
                this.menuItemSet.add(menuItem);
                this.log.debug((Object)("Menuitem " + menuItem + " for section " + sectionDescriptor + " added to menuitem cache for section " + this.sectionDescriptor));
            }
        }
        catch (SQLException e) {
            this.log.error((Object)("Error " + e + " getting menuIndex for menuitem from section " + sectionDescriptor));
        }
        finally {
            this.w.unlock();
        }
    }

    private SectionMenuItem createMenuItem(SectionDescriptor sectionDescriptor) {
        SectionMenuItem menuItem = new SectionMenuItem();
        menuItem.setAdminAccess(sectionDescriptor.allowsAdminAccess());
        menuItem.setUserAccess(sectionDescriptor.allowsUserAccess());
        menuItem.setAnonymousAccess(sectionDescriptor.allowsAnonymousAccess());
        menuItem.setDescription(sectionDescriptor.getDescription());
        menuItem.setName(sectionDescriptor.getName());
        menuItem.setUrl(sectionDescriptor.getFullAlias());
        menuItem.setUrlType(URLType.RELATIVE_FROM_CONTEXTPATH);
        menuItem.setSectionID(this.sectionDescriptor.getSectionID());
        menuItem.setSubSectionID(sectionDescriptor.getSectionID());
        menuItem.setAllowedGroupIDs(sectionDescriptor.getAllowedGroupIDs());
        menuItem.setAllowedUserIDs(sectionDescriptor.getAllowedUserIDs());
        return menuItem;
    }

    @Override
    public void sectionUnloaded(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
        this.w.lock();
        try {
            if (this.sectionMenuItemMap.containsKey(sectionDescriptor)) {
                this.log.debug((Object)("Removing " + sectionDescriptor + " from menuitem cache for section " + this.sectionDescriptor));
                this.menuItemSet.remove(this.sectionMenuItemMap.get(sectionDescriptor));
                this.sectionMenuItemMap.remove(sectionDescriptor);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sectionUpdated(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
        this.w.lock();
        try {
            if (sectionDescriptor.isVisibleInMenu()) {
                this.log.debug((Object)("Adding to section " + sectionDescriptor + " to menuitem cache for section " + this.sectionDescriptor));
                SectionMenuItem menuItem = this.createMenuItem(sectionDescriptor);
                SectionMenuItem oldMenuItem = this.sectionMenuItemMap.get(sectionDescriptor);
                if (oldMenuItem != null) {
                    this.menuItemSet.remove(oldMenuItem);
                }
                this.menuIndexDAO.populateSectionMenuIndex(menuItem);
                this.sectionMenuItemMap.put(sectionDescriptor, menuItem);
                this.menuItemSet.add(menuItem);
                this.log.debug((Object)("Menuitem " + menuItem + " for section " + sectionDescriptor + " added to menuitem cache for section " + this.sectionDescriptor));
            } else if (this.sectionMenuItemMap.containsKey(sectionDescriptor)) {
                this.menuItemSet.remove(this.sectionMenuItemMap.get(sectionDescriptor));
                this.sectionMenuItemMap.remove(sectionDescriptor);
            }
        }
        catch (SQLException e) {
            this.log.error((Object)("Error " + e + " getting menuIndex for menuitem from section " + sectionDescriptor + " in section " + this.sectionDescriptor));
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SectionMenu getUserMenu(User user, SectionMenu subMenu, URIParser uriParser) {
        try {
            this.r.lock();
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>(this.menuItemSet.size());
            for (MenuItem menuItem : this.menuItemSet) {
                Bundle bundle;
                if (!AccessUtils.checkAccess(user, menuItem)) continue;
                if (subMenu != null && menuItem instanceof SectionMenuItem && ((SectionMenuItem)menuItem).getSubSectionID() == subMenu.getSectionID()) {
                    menuItems.add(((SectionMenuItem)menuItem).clone(subMenu, true));
                    subMenu = null;
                    continue;
                }
                if (this.isSelected(menuItem, uriParser)) {
                    menuItems.add(menuItem.getSelectedClone());
                } else {
                    menuItems.add(menuItem);
                }
                if (!(menuItem instanceof Bundle) || (bundle = (Bundle)menuItem).getModuleMenuItems() == null) continue;
                for (ModuleMenuItem moduleMenuItem : bundle.getModuleMenuItems()) {
                    if (!AccessUtils.checkAccess(user, moduleMenuItem)) continue;
                    if (this.isSelected(moduleMenuItem, uriParser)) {
                        menuItems.add(moduleMenuItem.getSelectedClone());
                        continue;
                    }
                    menuItems.add(moduleMenuItem);
                }
            }
            SectionMenu sectionMenu = new SectionMenu(menuItems, this.sectionDescriptor);
            return sectionMenu;
        }
        finally {
            this.r.unlock();
        }
    }

    private boolean isSelected(MenuItem menuItem, URIParser uriParser) {
        if (uriParser == null) {
            return false;
        }
        if (menuItem.getUrl() != null) {
            if (menuItem.getUrlType() == URLType.FULL && (uriParser.getRequestURL().equals(menuItem.getUrl()) || uriParser.getRequestURL().startsWith(menuItem.getUrl() + "/"))) {
                return true;
            }
            if (menuItem.getUrlType() == URLType.RELATIVE_FROM_CONTEXTPATH && (uriParser.getFormattedURI().equals(menuItem.getUrl()) || uriParser.getFormattedURI().startsWith(menuItem.getUrl() + "/"))) {
                return true;
            }
        }
        return false;
    }

    public void sortMenu(MenuSorter menuSorter) {
        this.w.lock();
        try {
            menuSorter.sort(new ArrayList<MenuItem>(this.menuItemSet));
            this.rebuildIndex();
            this.saveIndex();
        }
        finally {
            this.w.unlock();
        }
    }
}

