/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.enums.PathType;
import se.unlogic.hierarchy.core.exceptions.ResourceNotFoundException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ModuleTransformerCache;
import se.unlogic.hierarchy.core.interfaces.VisibleModuleDescriptor;
import se.unlogic.standardutils.xml.ClassPathURIResolver;
import se.unlogic.standardutils.xsl.FileXSLTransformer;
import se.unlogic.standardutils.xsl.URIXSLTransformer;
import se.unlogic.standardutils.xsl.XSLTransformer;

public class ForegroundModuleXSLTCache
implements ForegroundModuleCacheListener,
ModuleTransformerCache<ForegroundModuleDescriptor> {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final HashMap<ForegroundModuleDescriptor, XSLTransformer> xslMap = new HashMap();
    private final String applicationFileSystemPath;
    private final Logger log = Logger.getLogger(this.getClass());

    public ForegroundModuleXSLTCache(String applicationFileSystemPath) {
        this.applicationFileSystemPath = applicationFileSystemPath;
    }

    public void clearModules() {
        this.w.lock();
        try {
            this.log.debug((Object)"Clearing module XSL cache");
            this.xslMap.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleCached(ForegroundModuleDescriptor mb, ForegroundModule moduleInstance) {
        this.w.lock();
        try {
            XSLTransformer xsltCacher = this.getCachedXslStyleSheet(mb);
            if (xsltCacher != null) {
                this.log.debug((Object)("Caching XSL stylesheet for " + mb));
                this.xslMap.put(mb, xsltCacher);
            }
        }
        catch (TransformerConfigurationException e) {
            this.log.error((Object)("Error caching XSL stylesheet for " + mb + ", " + e));
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Error caching XSL stylesheet for " + mb + ", " + e));
        }
        catch (URISyntaxException e) {
            this.log.error((Object)("Error caching XSL stylesheet for " + mb + ", " + e));
        }
        catch (ResourceNotFoundException e) {
            this.log.error((Object)("Error caching XSL stylesheet for " + mb + ", " + e));
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void moduleUnloaded(ForegroundModuleDescriptor mb, ForegroundModule moduleInstance) {
        this.w.lock();
        try {
            if (this.xslMap.containsKey(mb)) {
                this.log.debug((Object)("Unloading XSL stylesheet for " + mb));
                this.xslMap.remove(mb);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleUpdated(ForegroundModuleDescriptor mb, ForegroundModule moduleInstance) {
        this.w.lock();
        try {
            if (mb.hasStyleSheet()) {
                if (this.xslMap.containsKey(mb)) {
                    VisibleModuleDescriptor oldmb = null;
                    for (ForegroundModuleDescriptor mbx : this.xslMap.keySet()) {
                        if (!mbx.equals(mb)) continue;
                        oldmb = mbx;
                        break;
                    }
                    if (oldmb.getXslPathType().equals((Object)mb.getXslPathType()) && oldmb.getXslPath().equals(mb.getXslPath())) {
                        try {
                            this.log.debug((Object)("Reloading XSL stylesheet for " + mb));
                            this.xslMap.get(mb).reloadStyleSheet();
                        }
                        catch (TransformerConfigurationException e) {
                            this.log.error((Object)("Error reloading XSL stylesheet for " + mb + ", " + e));
                        }
                    } else {
                        this.moduleCached(mb, moduleInstance);
                    }
                } else {
                    this.moduleCached(mb, moduleInstance);
                }
            } else {
                this.moduleUnloaded(mb, moduleInstance);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private XSLTransformer getCachedXslStyleSheet(ForegroundModuleDescriptor mb) throws TransformerConfigurationException, ClassNotFoundException, URISyntaxException, ResourceNotFoundException {
        if (mb.getXslPath() != null && mb.getXslPathType() != null) {
            if (mb.getXslPathType() == PathType.Filesystem) {
                return new FileXSLTransformer(new File(mb.getXslPath()), (URIResolver)ClassPathURIResolver.getInstance());
            }
            if (mb.getXslPathType() == PathType.RealtiveFilesystem) {
                return new FileXSLTransformer(new File(this.applicationFileSystemPath + mb.getXslPath()), (URIResolver)ClassPathURIResolver.getInstance());
            }
            if (mb.getXslPathType() == PathType.Classpath) {
                URL styleSheetURL = Class.forName(mb.getClassname()).getResource(mb.getXslPath());
                if (styleSheetURL == null) {
                    throw new ResourceNotFoundException(mb.getClassname(), mb.getXslPath());
                }
                return new URIXSLTransformer(styleSheetURL.toURI(), (URIResolver)ClassPathURIResolver.getInstance(), true);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transformer getModuleTranformer(ForegroundModuleDescriptor mb) throws TransformerConfigurationException {
        this.r.lock();
        try {
            XSLTransformer xsltCacher = this.xslMap.get(mb);
            if (xsltCacher != null) {
                Transformer transformer = xsltCacher.getTransformer();
                return transformer;
            }
            Transformer transformer = null;
            return transformer;
        }
        finally {
            this.r.unlock();
        }
    }
}

