/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.unlogic.hierarchy.core.cache.BaseModuleCache;
import se.unlogic.hierarchy.core.daos.interfaces.ForegroundModuleDAO;
import se.unlogic.hierarchy.core.exceptions.AliasCollisonException;
import se.unlogic.hierarchy.core.exceptions.CachePreconditionException;
import se.unlogic.hierarchy.core.exceptions.InvalidModuleAliasException;
import se.unlogic.hierarchy.core.exceptions.InvalidModuleDescriptionException;
import se.unlogic.hierarchy.core.exceptions.InvalidModuleNameException;
import se.unlogic.hierarchy.core.exceptions.ModuleInitializationException;
import se.unlogic.hierarchy.core.exceptions.ModuleUnloadException;
import se.unlogic.hierarchy.core.exceptions.ModuleUpdateException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.string.StringUtils;

public class ForegroundModuleCache
extends BaseModuleCache<ForegroundModuleDescriptor, ForegroundModule, ForegroundModuleCacheListener> {
    private final SectionInterface sectionInterface;
    private final ForegroundModuleDAO moduleDAO;
    private final HashMap<String, ForegroundModuleDescriptor> aliasMap = new HashMap();

    public ForegroundModuleCache(SectionInterface sectionInterface) {
        super(sectionInterface.getSystemInterface());
        this.sectionInterface = sectionInterface;
        this.moduleDAO = sectionInterface.getSystemInterface().getCoreDaoFactory().getForegroundModuleDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheModules(boolean syncWithDB) throws KeyNotCachedException, KeyAlreadyCachedException, SQLException {
        this.w.lock();
        try {
            List moduleDescriptorBeanList = this.moduleDAO.getEnabledModules(this.sectionInterface.getSectionDescriptor().getSectionID());
            if (moduleDescriptorBeanList != null && moduleDescriptorBeanList.size() > 0) {
                if (syncWithDB) {
                    this.log.debug((Object)("Checking cache for modules to unload in section " + this.sectionInterface.getSectionDescriptor() + "..."));
                    if (!this.instanceMap.isEmpty()) {
                        ArrayList keys = new ArrayList(this.instanceMap.keySet());
                        for (ForegroundModuleDescriptor moduleDescriptor : keys) {
                            if (moduleDescriptorBeanList.contains(moduleDescriptor)) continue;
                            this.log.info((Object)("Module " + moduleDescriptor + " not found in new Module list for section " + this.sectionInterface.getSectionDescriptor() + ", removing from cache..."));
                            try {
                                this.unload(moduleDescriptor);
                            }
                            catch (Throwable e) {
                                this.log.error((Object)("Error unloading module " + moduleDescriptor + " from module cache in section " + this.sectionInterface.getSectionDescriptor()), e);
                            }
                        }
                        this.log.debug((Object)("Finished checking cache for modules to unload in section " + this.sectionInterface.getSectionDescriptor()));
                    } else {
                        this.log.debug((Object)("Cache is empty, no modules to unload in section " + this.sectionInterface.getSectionDescriptor()));
                    }
                }
                this.log.debug((Object)("Adding new modules to cache and refreshing cached modules for section " + this.sectionInterface.getSectionDescriptor() + "..."));
                for (ForegroundModuleDescriptor moduleDescriptor : moduleDescriptorBeanList) {
                    if (this.instanceMap.containsKey(moduleDescriptor)) {
                        try {
                            this.update(moduleDescriptor);
                        }
                        catch (Throwable e) {
                            this.log.error((Object)("Error updating module " + moduleDescriptor + " in section " + this.sectionInterface.getSectionDescriptor()), e);
                        }
                        continue;
                    }
                    this.log.info((Object)("Adding module " + moduleDescriptor + " to cache for section " + this.sectionInterface.getSectionDescriptor() + "..."));
                    try {
                        this.cache(moduleDescriptor);
                    }
                    catch (Throwable e) {
                        this.log.error((Object)("Error caching new instance of module " + moduleDescriptor + "for section " + this.sectionInterface.getSectionDescriptor()), e);
                    }
                }
                this.log.debug((Object)("Finished adding new modules and updating cached modules in section " + this.sectionInterface.getSectionDescriptor()));
            } else {
                this.log.debug((Object)("No modules found in database, for section " + this.sectionInterface.getSectionDescriptor()));
                if (syncWithDB) {
                    this.unload();
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    protected void moduleCached(ForegroundModuleDescriptor descriptor, ForegroundModule instance) {
        this.log.debug((Object)("Cached foreground module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
        this.aliasMap.put(descriptor.getAlias(), descriptor);
        for (ForegroundModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleCached(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while caching foreground module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void moduleUpdated(ForegroundModuleDescriptor descriptor, ForegroundModule instance) {
        this.log.debug((Object)("Updated foreground module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
        this.removeFromAliasMap(descriptor);
        this.aliasMap.put(descriptor.getAlias(), descriptor);
        for (ForegroundModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleUpdated(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while updating foreground module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void moduleUnloaded(ForegroundModuleDescriptor descriptor, ForegroundModule instance) {
        this.log.debug((Object)("Unloaded foreground module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
        this.removeFromAliasMap(descriptor);
        for (ForegroundModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleUnloaded(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while unloading foreground module " + descriptor), (Throwable)e);
            }
        }
    }

    protected void removeFromAliasMap(ForegroundModuleDescriptor descriptor) {
        this.aliasMap.values().remove(descriptor);
    }

    @Override
    protected void checkCachePreconditions(ForegroundModuleDescriptor descriptor) throws CachePreconditionException {
        this.validateDescritor(descriptor);
        ForegroundModuleDescriptor conflictingDescriptor = this.aliasMap.get(descriptor.getAlias());
        if (conflictingDescriptor != null) {
            throw new AliasCollisonException((ModuleDescriptor)descriptor, conflictingDescriptor);
        }
        for (ForegroundModuleDescriptor moduleDescriptor : this.cacheInProgressSet) {
            if (!moduleDescriptor.getAlias().equals(descriptor.getAlias()) || moduleDescriptor.equals(descriptor)) continue;
            throw new AliasCollisonException((ModuleDescriptor)descriptor, moduleDescriptor);
        }
        for (ForegroundModuleDescriptor moduleDescriptor : this.updateInProgressSet) {
            if (!moduleDescriptor.getAlias().equals(descriptor.getAlias())) continue;
            throw new AliasCollisonException((ModuleDescriptor)descriptor, moduleDescriptor);
        }
    }

    @Override
    protected void checkUpdatePreconditions(ForegroundModuleDescriptor descriptor) throws CachePreconditionException {
        this.validateDescritor(descriptor);
        ForegroundModuleDescriptor conflictingDescriptor = this.aliasMap.get(descriptor.getAlias());
        if (conflictingDescriptor != null && !conflictingDescriptor.equals(descriptor)) {
            throw new AliasCollisonException((ModuleDescriptor)descriptor, conflictingDescriptor);
        }
        for (ForegroundModuleDescriptor moduleDescriptor : this.cacheInProgressSet) {
            if (!moduleDescriptor.getAlias().equals(descriptor.getAlias())) continue;
            throw new AliasCollisonException((ModuleDescriptor)descriptor, moduleDescriptor);
        }
        for (ForegroundModuleDescriptor moduleDescriptor : this.updateInProgressSet) {
            if (!moduleDescriptor.getAlias().equals(descriptor.getAlias()) || moduleDescriptor.equals(descriptor)) continue;
            throw new AliasCollisonException((ModuleDescriptor)descriptor, moduleDescriptor);
        }
    }

    private void validateDescritor(ForegroundModuleDescriptor descriptor) throws InvalidModuleAliasException, InvalidModuleNameException, InvalidModuleDescriptionException {
        if (StringUtils.isEmpty((String)descriptor.getAlias())) {
            throw new InvalidModuleAliasException(descriptor);
        }
        if (StringUtils.isEmpty((String)descriptor.getName())) {
            throw new InvalidModuleNameException(descriptor);
        }
        if (StringUtils.isEmpty((String)descriptor.getDescription())) {
            throw new InvalidModuleDescriptionException(descriptor);
        }
    }

    @Override
    protected void initializeModule(ForegroundModuleDescriptor descriptor, ForegroundModule instance) throws ModuleInitializationException {
        try {
            instance.init(descriptor, this.sectionInterface, this.getDataSource(descriptor.getDataSourceID()));
        }
        catch (Exception e) {
            throw new ModuleInitializationException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void updateModule(ForegroundModuleDescriptor descriptor, ForegroundModule instance) throws ModuleUpdateException {
        try {
            instance.update(descriptor, this.getDataSource(descriptor.getDataSourceID()));
        }
        catch (Exception e) {
            throw new ModuleUpdateException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void unloadModule(ForegroundModuleDescriptor descriptor, ForegroundModule instance) throws ModuleUnloadException {
        try {
            instance.unload();
        }
        catch (Exception e) {
            throw new ModuleUnloadException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void unloadModuleSilently(ForegroundModuleDescriptor descriptor, ForegroundModule instance) {
        try {
            this.unloadModule(descriptor, instance);
        }
        catch (ModuleUnloadException e) {
            this.log.error((Object)("Error unloading foreground module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<ForegroundModuleDescriptor, ForegroundModule> getEntry(String alias) {
        this.r.lock();
        try {
            ForegroundModuleDescriptor descriptor = this.aliasMap.get(alias);
            if (descriptor == null) {
                Map.Entry<ForegroundModuleDescriptor, ForegroundModule> entry = null;
                return entry;
            }
            ForegroundModule instance = (ForegroundModule)this.instanceMap.get(descriptor);
            if (instance == null) {
                Map.Entry<ForegroundModuleDescriptor, ForegroundModule> entry = null;
                return entry;
            }
            SimpleEntry simpleEntry = new SimpleEntry((Object)descriptor, (Object)instance);
            return simpleEntry;
        }
        finally {
            this.r.unlock();
        }
    }
}

