/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.hierarchy.core.beans.SimpleFilterModuleDescriptor;
import se.unlogic.hierarchy.core.cache.WildcardModuleCache;
import se.unlogic.hierarchy.core.daos.interfaces.FilterModuleDAO;
import se.unlogic.hierarchy.core.exceptions.CachePreconditionException;
import se.unlogic.hierarchy.core.exceptions.ModuleInitializationException;
import se.unlogic.hierarchy.core.exceptions.ModuleUnloadException;
import se.unlogic.hierarchy.core.exceptions.ModuleUpdateException;
import se.unlogic.hierarchy.core.interfaces.FilterModule;
import se.unlogic.hierarchy.core.interfaces.FilterModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.FilterModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;

public class FilterModuleCache
extends WildcardModuleCache<FilterModuleDescriptor, FilterModule, FilterModuleCacheListener> {
    private final FilterModuleDAO moduleDAO;

    public FilterModuleCache(SystemInterface systemInterface) {
        super(systemInterface);
        this.moduleDAO = systemInterface.getCoreDaoFactory().getFilterModuleDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheModules(boolean unload) throws KeyNotCachedException, KeyAlreadyCachedException, SQLException {
        this.w.lock();
        try {
            List<SimpleFilterModuleDescriptor> moduleDescriptorBeanList = this.moduleDAO.getEnabledModules();
            if (moduleDescriptorBeanList != null && moduleDescriptorBeanList.size() > 0) {
                if (unload) {
                    this.log.debug((Object)"Checking cache for filter modules to unload...");
                    if (!this.instanceMap.isEmpty()) {
                        ArrayList keys = new ArrayList(this.instanceMap.keySet());
                        for (FilterModuleDescriptor moduleDescriptor : keys) {
                            if (moduleDescriptorBeanList.contains(moduleDescriptor)) continue;
                            this.log.info((Object)("Filter module " + moduleDescriptor + " not found in new module list, removing from cache..."));
                            try {
                                this.unload(moduleDescriptor);
                            }
                            catch (Throwable e) {
                                this.log.error((Object)("Error unloading filter module " + moduleDescriptor + " from module cache"), e);
                            }
                        }
                        this.log.debug((Object)"Finished checking cache for filter modules to unload");
                    } else {
                        this.log.debug((Object)"Cache is empty, no filter modules to unload");
                    }
                }
                this.log.debug((Object)"Adding new filter modules to cache and refreshing cached filter modules");
                for (FilterModuleDescriptor filterModuleDescriptor : moduleDescriptorBeanList) {
                    if (this.instanceMap.containsKey(filterModuleDescriptor)) {
                        try {
                            this.update(filterModuleDescriptor);
                        }
                        catch (Throwable e) {
                            this.log.error((Object)("Error updating filter module " + filterModuleDescriptor), e);
                        }
                        continue;
                    }
                    this.log.info((Object)("Adding filter module " + filterModuleDescriptor + " to cache"));
                    try {
                        this.cache(filterModuleDescriptor);
                    }
                    catch (Throwable e) {
                        this.log.error((Object)("Error caching new instance of filter module " + filterModuleDescriptor), e);
                    }
                }
                this.log.debug((Object)"Finished adding new filter modules and updating cached filter modules");
            } else {
                this.log.debug((Object)"No filter modules found in database");
                this.unload();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    protected void moduleCached(FilterModuleDescriptor descriptor, FilterModule instance) {
        this.log.debug((Object)("Cached filter module " + descriptor));
        this.setAliasMappings(descriptor);
        for (FilterModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleCached(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while caching filter module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void moduleUpdated(FilterModuleDescriptor descriptor, FilterModule instance) {
        this.log.debug((Object)("Updated backround module " + descriptor));
        this.removeAliasMappings(descriptor);
        this.setAliasMappings(descriptor);
        for (FilterModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleUpdated(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while updating filter module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void moduleUnloaded(FilterModuleDescriptor descriptor, FilterModule instance) {
        this.log.debug((Object)("Unloaded filter module " + descriptor));
        this.removeAliasMappings(descriptor);
        for (FilterModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleUnloaded(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while unloading filter module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void checkCachePreconditions(FilterModuleDescriptor descriptor) throws CachePreconditionException {
        this.validateDescritor(descriptor);
    }

    @Override
    protected void checkUpdatePreconditions(FilterModuleDescriptor descriptor) throws CachePreconditionException {
        this.validateDescritor(descriptor);
    }

    @Override
    protected void initializeModule(FilterModuleDescriptor descriptor, FilterModule instance) throws ModuleInitializationException {
        try {
            instance.init(descriptor, this.systemInterface, this.getDataSource(descriptor.getDataSourceID()));
        }
        catch (Exception e) {
            throw new ModuleInitializationException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void updateModule(FilterModuleDescriptor descriptor, FilterModule instance) throws ModuleUpdateException {
        try {
            instance.update(descriptor, this.getDataSource(descriptor.getDataSourceID()));
        }
        catch (Exception e) {
            throw new ModuleUpdateException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void unloadModule(FilterModuleDescriptor descriptor, FilterModule instance) throws ModuleUnloadException {
        try {
            instance.unload();
        }
        catch (Exception e) {
            throw new ModuleUnloadException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void unloadModuleSilently(FilterModuleDescriptor descriptor, FilterModule instance) {
        try {
            this.unloadModule(descriptor, instance);
        }
        catch (ModuleUnloadException e) {
            this.log.error((Object)("Error unloading filter module " + descriptor), (Throwable)e);
        }
    }
}

