/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.DataSourceDescriptor;
import se.unlogic.hierarchy.core.beans.DataSourceWrapper;
import se.unlogic.hierarchy.core.beans.SimpleDataSourceDescriptor;
import se.unlogic.hierarchy.core.daos.factories.CoreDaoFactory;
import se.unlogic.hierarchy.core.daos.interfaces.DataSourceDAO;
import se.unlogic.hierarchy.core.enums.DataSourceType;
import se.unlogic.hierarchy.core.exceptions.DataSourceDisabledException;
import se.unlogic.hierarchy.core.exceptions.DataSourceInstantiationException;
import se.unlogic.hierarchy.core.exceptions.DataSourceNotFoundException;
import se.unlogic.hierarchy.core.exceptions.DataSourceNotFoundInContextException;
import se.unlogic.hierarchy.core.utils.DBCPUtils;
import se.unlogic.standardutils.db.DBUtils;

public class DataSourceCache {
    private static final Logger log = Logger.getLogger(DataSourceCache.class);
    private final HashMap<DataSourceDescriptor, DataSourceWrapper> dataSourceMap = new HashMap();
    private final WeakHashMap<DataSourceDescriptor, DataSourceWrapper> stoppedDataSourceMap = new WeakHashMap();
    private final DataSourceDAO dataSourceDAO;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public DataSourceCache(CoreDaoFactory coreDaoFactory) {
        this.dataSourceDAO = coreDaoFactory.getDataSourceDAO();
    }

    private DataSource cacheDataSource(DataSourceDescriptor dataSourceDescriptor) throws SQLException, DataSourceDisabledException, DataSourceNotFoundInContextException {
        if (dataSourceDescriptor.isEnabled()) {
            log.info((Object)("Caching datasource " + dataSourceDescriptor));
            DataSourceWrapper stoppableDatasource = this.stoppedDataSourceMap.get(dataSourceDescriptor);
            if (stoppableDatasource != null) {
                stoppableDatasource.setDataSource(this.getDataSourceInstance(dataSourceDescriptor));
                this.stoppedDataSourceMap.remove(dataSourceDescriptor);
            } else {
                stoppableDatasource = new DataSourceWrapper(this.getDataSourceInstance(dataSourceDescriptor), this, dataSourceDescriptor.getDataSourceID());
            }
            this.dataSourceMap.put(dataSourceDescriptor, stoppableDatasource);
            return stoppableDatasource;
        }
        throw new DataSourceDisabledException(dataSourceDescriptor);
    }

    private DataSource getDataSourceInstance(DataSourceDescriptor dataSourceDescriptor) throws SQLException, DataSourceNotFoundInContextException {
        if (dataSourceDescriptor.getType() == DataSourceType.ContainerManaged) {
            try {
                return DBUtils.getDataSource((String)dataSourceDescriptor.getUrl());
            }
            catch (NamingException e) {
                throw new DataSourceNotFoundInContextException(dataSourceDescriptor, e);
            }
        }
        BasicDataSource basicDataSource = DBCPUtils.createConnectionPool(dataSourceDescriptor);
        try {
            basicDataSource.getLogWriter();
            return basicDataSource;
        }
        catch (SQLException e) {
            if (basicDataSource != null) {
                try {
                    basicDataSource.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Error closing data source after failed initialization", (Throwable)e);
                }
            }
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    public DataSource getDataSource(int dataSourceID) throws DataSourceNotFoundException, DataSourceInstantiationException, DataSourceDisabledException, DataSourceNotFoundInContextException {
        block10: {
            SimpleDataSourceDescriptor dataSourceDescriptor;
            block9: {
                block8: {
                    try {
                        this.w.lock();
                        DataSourceWrapper dataSource = this.getCachedDataSource(dataSourceID);
                        if (dataSource == null) break block8;
                        DataSourceWrapper dataSourceWrapper = dataSource;
                        this.w.unlock();
                        return dataSourceWrapper;
                    }
                    catch (Throwable throwable) {
                        this.w.unlock();
                        throw throwable;
                    }
                }
                dataSourceDescriptor = this.dataSourceDAO.get(dataSourceID);
                if (dataSourceDescriptor == null) break block9;
                DataSource dataSource = this.cacheDataSource(dataSourceDescriptor);
                this.w.unlock();
                return dataSource;
            }
            try {
                break block10;
                {
                    catch (SQLException e) {
                        log.debug((Object)("Error instantating data source " + dataSourceDescriptor), (Throwable)e);
                        throw new DataSourceInstantiationException(dataSourceDescriptor, e);
                    }
                }
            }
            catch (SQLException e) {
                log.error((Object)("Error getting data source descriptor from DB for data source with ID " + dataSourceID), (Throwable)e);
            }
        }
        throw new DataSourceNotFoundException(dataSourceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(DataSourceDescriptor dataSourceDescriptor) throws SQLException, DataSourceDisabledException, DataSourceNotFoundInContextException {
        try {
            this.w.lock();
            DataSourceWrapper dataSource = this.getCachedDataSource(dataSourceDescriptor.getDataSourceID());
            if (dataSource != null) {
                DataSourceWrapper dataSourceWrapper = dataSource;
                return dataSourceWrapper;
            }
            DataSource dataSource2 = this.cacheDataSource(dataSourceDescriptor);
            return dataSource2;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DataSourceDescriptor dataSourceDescriptor) throws SQLException, DataSourceNotFoundInContextException {
        block9: {
            try {
                DataSource dataSource;
                this.w.lock();
                Map.Entry<DataSourceDescriptor, DataSourceWrapper> cachedEntry = this.getCachedDataSourceEntry(dataSourceDescriptor.getDataSourceID());
                if (cachedEntry == null) break block9;
                DataSourceDescriptor oldDescritor = cachedEntry.getKey();
                DataSourceWrapper dataSourceWrapper = cachedEntry.getValue();
                log.info((Object)("Updating cached datasource " + oldDescritor));
                BasicDataSource oldDataSourceInstance = null;
                if (oldDescritor.getType() == DataSourceType.SystemManaged && dataSourceWrapper.getDataSource() instanceof BasicDataSource) {
                    oldDataSourceInstance = (BasicDataSource)dataSourceWrapper.getDataSource();
                }
                try {
                    dataSource = this.getDataSourceInstance(dataSourceDescriptor);
                }
                catch (SQLException e) {
                    log.error((Object)("Error updating data source " + dataSourceDescriptor), (Throwable)e);
                    throw e;
                }
                dataSourceWrapper.setDataSource(dataSource);
                this.dataSourceMap.remove(dataSourceDescriptor);
                this.dataSourceMap.put(dataSourceDescriptor, dataSourceWrapper);
                if (oldDataSourceInstance != null) {
                    try {
                        oldDataSourceInstance.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Error closing old instance datasource " + oldDescritor + " after update"));
                    }
                }
            }
            finally {
                this.w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int dataSourceID) {
        try {
            this.w.lock();
            Map.Entry<DataSourceDescriptor, DataSourceWrapper> cachedEntry = this.getCachedDataSourceEntry(dataSourceID);
            if (cachedEntry != null) {
                DataSourceDescriptor descriptor = cachedEntry.getKey();
                DataSourceWrapper dataSourceWrapper = cachedEntry.getValue();
                log.info((Object)("Stopping datasource " + descriptor));
                BasicDataSource dataSourceInstance = null;
                if (descriptor.getType() == DataSourceType.SystemManaged && dataSourceWrapper.getDataSource() instanceof BasicDataSource) {
                    dataSourceInstance = (BasicDataSource)dataSourceWrapper.getDataSource();
                }
                dataSourceWrapper.stop();
                this.dataSourceMap.remove(descriptor);
                this.stoppedDataSourceMap.put(descriptor, dataSourceWrapper);
                if (dataSourceInstance != null) {
                    try {
                        dataSourceInstance.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Error closing datasource " + descriptor), (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int dataSourceID) {
        try {
            this.w.lock();
            Map.Entry<DataSourceDescriptor, DataSourceWrapper> cachedEntry = this.getCachedDataSourceEntry(dataSourceID);
            if (cachedEntry != null) {
                DataSourceDescriptor descriptor = cachedEntry.getKey();
                DataSourceWrapper dataSourceWrapper = cachedEntry.getValue();
                log.info((Object)("Deleting datasource " + descriptor));
                BasicDataSource dataSourceInstance = null;
                if (descriptor.getType() == DataSourceType.SystemManaged && dataSourceWrapper.getDataSource() instanceof BasicDataSource) {
                    dataSourceInstance = (BasicDataSource)dataSourceWrapper.getDataSource();
                }
                dataSourceWrapper.delete();
                this.dataSourceMap.remove(descriptor);
                this.stoppedDataSourceMap.remove(descriptor);
                if (dataSourceInstance != null) {
                    try {
                        dataSourceInstance.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Error closing datasource " + descriptor));
                    }
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private DataSourceWrapper getCachedDataSource(int dataSourceID) {
        Map.Entry<DataSourceDescriptor, DataSourceWrapper> cachedEntry = this.getCachedDataSourceEntry(dataSourceID);
        if (cachedEntry != null) {
            return cachedEntry.getValue();
        }
        return null;
    }

    private Map.Entry<DataSourceDescriptor, DataSourceWrapper> getCachedDataSourceEntry(int dataSourceID) {
        for (Map.Entry<DataSourceDescriptor, DataSourceWrapper> entry : this.dataSourceMap.entrySet()) {
            if (entry.getKey().getDataSourceID() != dataSourceID) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceDescriptor getCachedDataSourceDescriptor(int dataSourceID) {
        try {
            this.r.lock();
            Map.Entry<DataSourceDescriptor, DataSourceWrapper> entry = this.getCachedDataSourceEntry(dataSourceID);
            if (entry != null) {
                DataSourceDescriptor dataSourceDescriptor = entry.getKey();
                return dataSourceDescriptor;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    public boolean isCached(int dataSourceID) {
        try {
            this.r.lock();
            boolean bl = this.getCachedDataSource(dataSourceID) != null;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isCached(DataSourceDescriptor dataSourceDescriptor) {
        try {
            this.r.lock();
            boolean bl = this.dataSourceMap.containsKey(dataSourceDescriptor);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isEmpty() {
        try {
            this.r.lock();
            boolean bl = this.dataSourceMap.isEmpty();
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public int size() {
        try {
            this.r.lock();
            int n = this.dataSourceMap.size();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    public ArrayList<DataSourceDescriptor> getCachedDataSourceDescriptors() {
        try {
            this.r.lock();
            ArrayList<DataSourceDescriptor> arrayList = new ArrayList<DataSourceDescriptor>(this.dataSourceMap.keySet());
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        try {
            this.w.lock();
            ArrayList<DataSourceDescriptor> descriptorList = this.getCachedDataSourceDescriptors();
            for (DataSourceDescriptor descriptor : descriptorList) {
                this.stop(descriptor.getDataSourceID());
            }
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver driver = e.nextElement();
                if (driver.getClass().getClassLoader() != this.getClass().getClassLoader()) continue;
                try {
                    log.info((Object)("Deregistering JDBC driver " + driver));
                    DriverManager.deregisterDriver(driver);
                }
                catch (SQLException e1) {
                    log.error((Object)("Error deregistering JDBC driver " + driver));
                }
            }
            log.info((Object)"Datasource cache unloaded");
        }
        finally {
            this.w.unlock();
        }
    }
}

