/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.io.File;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import se.unlogic.hierarchy.core.cache.NoDefaultCoreStylesheetFoundException;
import se.unlogic.hierarchy.core.cache.XSLCacheHandler;
import se.unlogic.hierarchy.core.exceptions.NoXSLStylesheetsFoundException;
import se.unlogic.standardutils.enums.EnumUtils;
import se.unlogic.standardutils.i18n.Language;
import se.unlogic.standardutils.settings.SettingNode;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.ClassPathURIResolver;
import se.unlogic.standardutils.xsl.FileXSLTransformer;
import se.unlogic.standardutils.xsl.XSLTransformer;

public class CoreXSLTCacheHandler
extends XSLCacheHandler {
    public CoreXSLTCacheHandler(SettingNode config, Language defaultLanguage, String applicationFileSystemPath) {
        super(defaultLanguage);
        List stylesheets = config.getNodes("/Config/StyleSheets/StyleSheet");
        for (SettingNode settingNode : stylesheets) {
            String path = settingNode.getString(".");
            String name = settingNode.getString("@name");
            Language language = (Language)EnumUtils.toEnum(Language.class, (String)settingNode.getString("@language"));
            boolean isDefault = settingNode.getBoolean("@default");
            boolean fullPath = settingNode.getBoolean("@pathtype = 'Full'");
            boolean useFullMenu = settingNode.getBoolean("@fullMenu");
            if (StringUtils.isEmpty((String)path)) {
                this.log.warn((Object)("Stylesheet " + name + " with no path set found in config, ignoring stylesheet."));
            } else {
                if (StringUtils.isEmpty((String)name)) {
                    this.log.warn((Object)("Stylesheet with no name set found in config (path " + path + "), ignoring stylesheet."));
                    continue;
                }
                if (language == null) {
                    this.log.warn((Object)("Stylesheet " + name + " with no or invalid language set found in config (path " + path + "), ignoring stylesheet."));
                    continue;
                }
            }
            try {
                FileXSLTransformer cachedXSLTFile = fullPath ? new FileXSLTransformer(new File(path), (URIResolver)ClassPathURIResolver.getInstance()) : new FileXSLTransformer(new File(applicationFileSystemPath + "WEB-INF/" + path), (URIResolver)ClassPathURIResolver.getInstance());
                this.add((XSLTransformer)cachedXSLTFile, language, name, isDefault, useFullMenu);
            }
            catch (TransformerConfigurationException e) {
                this.log.error((Object)("Error caching stylesheet " + name + " (path: " + path + ")"), (Throwable)e);
            }
        }
        if (this.getXslDescriptorCount() == 0) {
            throw new NoXSLStylesheetsFoundException();
        }
        if (this.defaultXsltDescriptor == null) {
            throw new NoDefaultCoreStylesheetFoundException("No default stylesheet found for default language " + defaultLanguage);
        }
    }
}

