/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.exceptions.CachePreconditionException;
import se.unlogic.hierarchy.core.exceptions.DataSourceDisabledException;
import se.unlogic.hierarchy.core.exceptions.DataSourceInstantiationException;
import se.unlogic.hierarchy.core.exceptions.DataSourceNotFoundException;
import se.unlogic.hierarchy.core.exceptions.DataSourceNotFoundInContextException;
import se.unlogic.hierarchy.core.exceptions.ModuleAlreadyBeingCachedException;
import se.unlogic.hierarchy.core.exceptions.ModuleAlreadyCachedException;
import se.unlogic.hierarchy.core.exceptions.ModuleInitializationException;
import se.unlogic.hierarchy.core.exceptions.ModuleInstasiationException;
import se.unlogic.hierarchy.core.exceptions.ModuleNotCachedException;
import se.unlogic.hierarchy.core.exceptions.ModuleUnloadException;
import se.unlogic.hierarchy.core.exceptions.ModuleUpdateException;
import se.unlogic.hierarchy.core.exceptions.ModuleUpdatedInProgressException;
import se.unlogic.hierarchy.core.interfaces.Module;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableAttributeHandler;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.reflection.ReflectionUtils;

public abstract class BaseModuleCache<DescriptorType extends ModuleDescriptor, ModuleType extends Module<?>, ListenerType> {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock r = this.rwl.readLock();
    protected final Lock w = this.rwl.writeLock();
    protected HashMap<DescriptorType, ModuleType> instanceMap = new HashMap();
    protected HashSet<DescriptorType> cacheInProgressSet = new HashSet();
    protected HashSet<DescriptorType> updateInProgressSet = new HashSet();
    protected CopyOnWriteArraySet<ListenerType> cacheListeners = new CopyOnWriteArraySet();
    protected final SystemInterface systemInterface;

    public BaseModuleCache(SystemInterface systemInterface) {
        this.systemInterface = systemInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleType cache(DescriptorType descriptor) throws ModuleAlreadyCachedException, ModuleAlreadyBeingCachedException, ModuleInstasiationException, ModuleInitializationException, CachePreconditionException {
        boolean addedToCacheInProgressSet = false;
        try {
            this.w.lock();
            try {
                if (this.instanceMap.containsKey(descriptor)) {
                    throw new ModuleAlreadyCachedException((ModuleDescriptor)descriptor);
                }
                this.checkCachePreconditions(descriptor);
                addedToCacheInProgressSet = this.cacheInProgressSet.add(descriptor);
                if (!addedToCacheInProgressSet) {
                    throw new ModuleAlreadyBeingCachedException((ModuleDescriptor)descriptor);
                }
            }
            finally {
                this.w.unlock();
            }
            ModuleType instance = this.createModuleInstance(descriptor);
            this.initializeModule(descriptor, instance);
            this.w.lock();
            try {
                this.instanceMap.put(descriptor, instance);
                this.moduleCached(descriptor, instance);
            }
            finally {
                this.w.unlock();
            }
            ModuleType ModuleType2 = instance;
            return ModuleType2;
        }
        finally {
            if (addedToCacheInProgressSet) {
                this.w.lock();
                try {
                    this.cacheInProgressSet.remove(descriptor);
                }
                finally {
                    this.w.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DescriptorType descriptor) throws ModuleNotCachedException, CachePreconditionException, ModuleUpdateException, ModuleUpdatedInProgressException {
        boolean addedToUpdateInProgressSet = false;
        try {
            Module instance;
            this.w.lock();
            try {
                instance = (Module)this.instanceMap.get(descriptor);
                if (instance == null) {
                    throw new ModuleNotCachedException((ModuleDescriptor)descriptor);
                }
                this.checkUpdatePreconditions(descriptor);
                addedToUpdateInProgressSet = this.updateInProgressSet.add(descriptor);
                if (!addedToUpdateInProgressSet) {
                    throw new ModuleUpdatedInProgressException((ModuleDescriptor)descriptor);
                }
            }
            finally {
                this.w.unlock();
            }
            this.updateModule(descriptor, instance);
            this.w.lock();
            try {
                this.instanceMap.remove(descriptor);
                this.instanceMap.put(descriptor, instance);
                this.moduleUpdated(descriptor, instance);
            }
            finally {
                this.w.unlock();
            }
        }
        finally {
            if (addedToUpdateInProgressSet) {
                this.w.lock();
                try {
                    this.updateInProgressSet.remove(descriptor);
                }
                finally {
                    this.w.unlock();
                }
            }
        }
    }

    public void unload(DescriptorType descriptor) throws ModuleNotCachedException, ModuleUnloadException, ModuleUpdatedInProgressException {
        Module instance;
        this.w.lock();
        try {
            instance = (Module)this.instanceMap.get(descriptor);
            if (instance == null) {
                throw new ModuleNotCachedException((ModuleDescriptor)descriptor);
            }
            if (this.updateInProgressSet.contains(descriptor)) {
                throw new ModuleUpdatedInProgressException((ModuleDescriptor)descriptor);
            }
            this.instanceMap.remove(descriptor);
            this.moduleUnloaded(descriptor, instance);
        }
        finally {
            this.w.unlock();
        }
        this.unloadModule(descriptor, instance);
    }

    public void unload() {
        this.w.lock();
        try {
            for (Map.Entry<DescriptorType, ModuleType> entry : this.instanceMap.entrySet()) {
                this.unloadModuleSilently((ModuleDescriptor)entry.getKey(), (Module)entry.getValue());
                this.moduleUnloaded((ModuleDescriptor)entry.getKey(), (Module)entry.getValue());
            }
        }
        finally {
            this.w.unlock();
        }
    }

    protected abstract void moduleCached(DescriptorType var1, ModuleType var2);

    protected abstract void moduleUpdated(DescriptorType var1, ModuleType var2);

    protected abstract void moduleUnloaded(DescriptorType var1, ModuleType var2);

    protected abstract void checkCachePreconditions(DescriptorType var1) throws CachePreconditionException;

    protected abstract void checkUpdatePreconditions(DescriptorType var1) throws CachePreconditionException;

    protected ModuleType createModuleInstance(DescriptorType descriptor) throws ModuleInstasiationException {
        try {
            return (ModuleType)((Module)ReflectionUtils.getInstance((String)descriptor.getClassname()));
        }
        catch (Throwable t) {
            throw new ModuleInstasiationException((ModuleDescriptor)descriptor, t);
        }
    }

    protected abstract void initializeModule(DescriptorType var1, ModuleType var2) throws ModuleInitializationException;

    protected abstract void updateModule(DescriptorType var1, ModuleType var2) throws ModuleUpdateException;

    protected abstract void unloadModule(DescriptorType var1, ModuleType var2) throws ModuleUnloadException;

    protected abstract void unloadModuleSilently(DescriptorType var1, ModuleType var2);

    protected DataSource getDataSource(Integer dataSourceID) throws SQLException, DataSourceNotFoundException, DataSourceInstantiationException, DataSourceDisabledException, DataSourceNotFoundInContextException {
        if (dataSourceID != null) {
            return this.systemInterface.getDataSourceCache().getDataSource(dataSourceID);
        }
        return this.systemInterface.getDataSource();
    }

    public boolean addCacheListener(ListenerType cacheListener) {
        return this.cacheListeners.add(cacheListener);
    }

    public boolean removeCacheListener(ListenerType cacheListener) {
        return this.cacheListeners.remove(cacheListener);
    }

    public boolean isCached(DescriptorType descriptor) {
        this.r.lock();
        try {
            boolean bl = this.instanceMap.containsKey(descriptor);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isBeingCached(DescriptorType descriptor) {
        this.r.lock();
        try {
            boolean bl = this.cacheInProgressSet.contains(descriptor);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Map.Entry<DescriptorType, ModuleType>> getCachedModules() {
        this.r.lock();
        try {
            Set<Map.Entry<DescriptorType, ModuleType>> entrySet = this.instanceMap.entrySet();
            ArrayList<SimpleEntry> entryList = new ArrayList<SimpleEntry>(entrySet.size());
            for (Map.Entry<DescriptorType, ModuleType> entry : entrySet) {
                entryList.add(new SimpleEntry(entry));
            }
            ArrayList<SimpleEntry> arrayList = entryList;
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    public ArrayList<DescriptorType> getCachedModuleDescriptors() {
        this.r.lock();
        try {
            ArrayList<DescriptorType> arrayList = new ArrayList<DescriptorType>(this.instanceMap.keySet());
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<DescriptorType, ModuleType> getEntry(Integer moduleID) {
        this.r.lock();
        try {
            for (Map.Entry<DescriptorType, ModuleType> entry : this.instanceMap.entrySet()) {
                Integer currentModuleID = ((ModuleDescriptor)entry.getKey()).getModuleID();
                if (currentModuleID == null || !currentModuleID.equals(moduleID)) continue;
                SimpleEntry simpleEntry = new SimpleEntry(entry);
                return simpleEntry;
            }
            Iterator<Map.Entry<DescriptorType, ModuleType>> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    public ModuleType getModule(DescriptorType descriptor) {
        this.r.lock();
        try {
            Module module = (Module)this.instanceMap.get(descriptor);
            return (ModuleType)module;
        }
        finally {
            this.r.unlock();
        }
    }

    public int size() {
        return this.instanceMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<DescriptorType, ModuleType> getEntryByHashCode(int hashCode) {
        this.r.lock();
        try {
            for (Map.Entry<DescriptorType, ModuleType> cacheEntry : this.instanceMap.entrySet()) {
                int currentModuleHashCode = ((ModuleDescriptor)cacheEntry.getKey()).hashCode();
                if (currentModuleHashCode != hashCode) continue;
                SimpleEntry simpleEntry = new SimpleEntry(cacheEntry);
                return simpleEntry;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ModuleType> Map.Entry<DescriptorType, T> getModuleEntryByClass(Class<T> clazz) {
        this.r.lock();
        try {
            for (Map.Entry<DescriptorType, ModuleType> cacheEntry : this.instanceMap.entrySet()) {
                if (!((Module)cacheEntry.getValue()).getClass().isAssignableFrom(clazz)) continue;
                SimpleEntry simpleEntry = new SimpleEntry(cacheEntry.getKey(), (Object)((Module)cacheEntry.getValue()));
                return simpleEntry;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    public DescriptorType getDescriptorByHashCode(int hashCode) {
        Map.Entry<DescriptorType, ModuleType> entry = this.getEntryByHashCode(hashCode);
        if (entry != null) {
            return (DescriptorType)((ModuleDescriptor)entry.getKey());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<DescriptorType, ModuleType> getModuleEntryByAttribute(String name, String value) {
        this.r.lock();
        try {
            for (Map.Entry<DescriptorType, ModuleType> cacheEntry : this.instanceMap.entrySet()) {
                String attributeValue;
                MutableAttributeHandler attributeHandler = ((ModuleDescriptor)cacheEntry.getKey()).getAttributeHandler();
                if (attributeHandler == null || !value.equals(attributeValue = attributeHandler.getString(name))) continue;
                SimpleEntry simpleEntry = new SimpleEntry(cacheEntry);
                return simpleEntry;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }
}

