/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.hierarchy.core.cache.WildcardModuleCache;
import se.unlogic.hierarchy.core.daos.interfaces.BackgroundModuleDAO;
import se.unlogic.hierarchy.core.exceptions.CachePreconditionException;
import se.unlogic.hierarchy.core.exceptions.ModuleInitializationException;
import se.unlogic.hierarchy.core.exceptions.ModuleUnloadException;
import se.unlogic.hierarchy.core.exceptions.ModuleUpdateException;
import se.unlogic.hierarchy.core.interfaces.BackgroundModule;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;

public class BackgroundModuleCache
extends WildcardModuleCache<BackgroundModuleDescriptor, BackgroundModule, BackgroundModuleCacheListener> {
    private final SectionInterface sectionInterface;
    private final BackgroundModuleDAO moduleDAO;

    public BackgroundModuleCache(SectionInterface sectionInterface) {
        super(sectionInterface.getSystemInterface());
        this.sectionInterface = sectionInterface;
        this.moduleDAO = sectionInterface.getSystemInterface().getCoreDaoFactory().getBackgroundModuleDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheModules(boolean syncWithDB) throws KeyNotCachedException, KeyAlreadyCachedException, SQLException {
        this.w.lock();
        try {
            List moduleDescriptorBeanList = this.moduleDAO.getEnabledModules(this.sectionInterface.getSectionDescriptor().getSectionID());
            if (moduleDescriptorBeanList != null && moduleDescriptorBeanList.size() > 0) {
                if (syncWithDB) {
                    this.log.debug((Object)("Checking cache for background modules to unload in section " + this.sectionInterface.getSectionDescriptor() + "..."));
                    if (!this.instanceMap.isEmpty()) {
                        ArrayList keys = new ArrayList(this.instanceMap.keySet());
                        for (BackgroundModuleDescriptor moduleDescriptor : keys) {
                            if (moduleDescriptorBeanList.contains(moduleDescriptor)) continue;
                            this.log.info((Object)("Background module " + moduleDescriptor + " not found in new module list for section " + this.sectionInterface.getSectionDescriptor() + ", removing from cache..."));
                            try {
                                this.unload(moduleDescriptor);
                            }
                            catch (Throwable e) {
                                this.log.error((Object)("Error unloading background module " + moduleDescriptor + " from background module cache in section " + this.sectionInterface.getSectionDescriptor()), e);
                            }
                        }
                        this.log.debug((Object)("Finished checking cache for background modules to unload in section " + this.sectionInterface.getSectionDescriptor()));
                    } else {
                        this.log.debug((Object)("Cache is empty, no background modules to unload in section " + this.sectionInterface.getSectionDescriptor()));
                    }
                }
                this.log.debug((Object)("Adding new background modules to cache and refreshing cached background modules for section " + this.sectionInterface.getSectionDescriptor() + "..."));
                for (BackgroundModuleDescriptor moduleDescriptor : moduleDescriptorBeanList) {
                    if (this.instanceMap.containsKey(moduleDescriptor)) {
                        try {
                            this.update(moduleDescriptor);
                        }
                        catch (Throwable e) {
                            this.log.error((Object)("Error updating background module " + moduleDescriptor + " in section " + this.sectionInterface.getSectionDescriptor()), e);
                        }
                        continue;
                    }
                    this.log.info((Object)("Adding background module " + moduleDescriptor + " to cache for section " + this.sectionInterface.getSectionDescriptor() + "..."));
                    try {
                        this.cache(moduleDescriptor);
                    }
                    catch (Throwable e) {
                        this.log.error((Object)("Error caching new instance of background module " + moduleDescriptor + "for section " + this.sectionInterface.getSectionDescriptor()), e);
                    }
                }
                this.log.debug((Object)("Finished adding new background modules and updating cached background modules in section " + this.sectionInterface.getSectionDescriptor()));
            } else {
                this.log.debug((Object)("No background modules found in database, for section " + this.sectionInterface.getSectionDescriptor()));
                if (syncWithDB) {
                    this.unload();
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    protected void moduleCached(BackgroundModuleDescriptor descriptor, BackgroundModule instance) {
        this.log.debug((Object)("Cached background module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
        this.setAliasMappings(descriptor);
        for (BackgroundModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleCached(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while caching background module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void moduleUpdated(BackgroundModuleDescriptor descriptor, BackgroundModule instance) {
        this.log.debug((Object)("Updated backround module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
        this.removeAliasMappings(descriptor);
        this.setAliasMappings(descriptor);
        for (BackgroundModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleUpdated(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while updating background module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void moduleUnloaded(BackgroundModuleDescriptor descriptor, BackgroundModule instance) {
        this.log.debug((Object)("Unloaded background module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()));
        this.removeAliasMappings(descriptor);
        for (BackgroundModuleCacheListener cacheListener : this.cacheListeners) {
            try {
                cacheListener.moduleUnloaded(descriptor, instance);
            }
            catch (Exception e) {
                this.log.error((Object)("Error in cachelistener " + cacheListener + " while unloading background module " + descriptor), (Throwable)e);
            }
        }
    }

    @Override
    protected void checkCachePreconditions(BackgroundModuleDescriptor descriptor) throws CachePreconditionException {
        this.validateDescritor(descriptor);
    }

    @Override
    protected void checkUpdatePreconditions(BackgroundModuleDescriptor descriptor) throws CachePreconditionException {
        this.validateDescritor(descriptor);
    }

    @Override
    protected void initializeModule(BackgroundModuleDescriptor descriptor, BackgroundModule instance) throws ModuleInitializationException {
        try {
            instance.init(descriptor, this.sectionInterface, this.getDataSource(descriptor.getDataSourceID()));
        }
        catch (Exception e) {
            throw new ModuleInitializationException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void updateModule(BackgroundModuleDescriptor descriptor, BackgroundModule instance) throws ModuleUpdateException {
        try {
            instance.update(descriptor, this.getDataSource(descriptor.getDataSourceID()));
        }
        catch (Exception e) {
            throw new ModuleUpdateException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void unloadModule(BackgroundModuleDescriptor descriptor, BackgroundModule instance) throws ModuleUnloadException {
        try {
            instance.unload();
        }
        catch (Exception e) {
            throw new ModuleUnloadException(descriptor, (Throwable)e);
        }
    }

    @Override
    protected void unloadModuleSilently(BackgroundModuleDescriptor descriptor, BackgroundModule instance) {
        try {
            this.unloadModule(descriptor, instance);
        }
        catch (ModuleUnloadException e) {
            this.log.error((Object)("Error unloading background module " + descriptor + " in section " + this.sectionInterface.getSectionDescriptor()), (Throwable)e);
        }
    }
}

