/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;

public class ValueDescriptor {
    private final String name;
    private final String value;

    public ValueDescriptor(String name, Object value) {
        this(name, value.toString());
    }

    public ValueDescriptor(String name, String value) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be empty");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Element toXML(Document doc) {
        Element valueDescriptorElement = doc.createElement("valueDescriptor");
        valueDescriptorElement.appendChild(XMLUtils.createElement((String)"name", (Object)this.name, (Document)doc));
        valueDescriptorElement.appendChild(XMLUtils.createElement((String)"value", (Object)this.value, (Document)doc));
        return valueDescriptorElement;
    }
}

