/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.MutableUser;
import se.unlogic.hierarchy.core.interfaces.AttributeHandler;
import se.unlogic.hierarchy.core.servlets.CoreServlet;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.i18n.Language;
import se.unlogic.standardutils.string.StringTag;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.SessionUtils;

public abstract class User
implements Serializable,
HttpSessionBindingListener,
Elementable {
    private static final long serialVersionUID = 3517714501615304468L;
    private final UserSingleton userSingleton = UserSingleton.getInstance();
    private HttpSession session;

    public abstract boolean isAdmin();

    @StringTag(name="email")
    public abstract String getEmail();

    @StringTag(name="firstname")
    public abstract String getFirstname();

    public abstract Timestamp getCurrentLogin();

    public abstract Timestamp getLastLogin();

    @StringTag(name="lastname")
    public abstract String getLastname();

    public abstract String getPassword();

    @StringTag(name="username")
    public abstract String getUsername();

    @StringTag(name="userID")
    public abstract Integer getUserID();

    public abstract boolean isEnabled();

    public abstract Timestamp getAdded();

    public abstract Collection<Group> getGroups();

    public abstract Language getLanguage();

    public abstract String getPreferedDesign();

    public abstract boolean hasFormProvider();

    public String toString() {
        if (this.getUserID() != null) {
            return this.getFirstname() + " " + this.getLastname() + " (ID: " + this.getUserID() + ")";
        }
        return this.getFirstname() + " " + this.getLastname() + " (" + this.getUsername() + ")";
    }

    public final Element toXML(Document doc) {
        Element sessionInfo;
        Element userElement = doc.createElement("user");
        if (this.getUserID() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"userID", (Object)this.getUserID().toString(), (Document)doc));
        }
        if (this.getUsername() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"username", (Object)this.getUsername(), (Document)doc));
        }
        if (this.getFirstname() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"firstname", (Object)this.getFirstname(), (Document)doc));
        }
        if (this.getLastname() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"lastname", (Object)this.getLastname(), (Document)doc));
        }
        if (this.getEmail() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"email", (Object)this.getEmail(), (Document)doc));
        }
        if (this.getLanguage() != null) {
            userElement.appendChild(this.getLanguage().toXML(doc));
        }
        userElement.appendChild(XMLUtils.createElement((String)"admin", (Object)Boolean.toString(this.isAdmin()), (Document)doc));
        userElement.appendChild(XMLUtils.createElement((String)"enabled", (Object)Boolean.toString(this.isEnabled()), (Document)doc));
        if (this.getLastLogin() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"lastLogin", (Object)DateUtils.DATE_TIME_FORMATTER.format((Date)this.getLastLogin()), (Document)doc));
            userElement.appendChild(XMLUtils.createElement((String)"lastLoginInMilliseconds", (Object)(this.getLastLogin().getTime() + ""), (Document)doc));
        }
        if (this.getCurrentLogin() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"currentLogin", (Object)DateUtils.DATE_TIME_FORMATTER.format((Date)this.getCurrentLogin()), (Document)doc));
            userElement.appendChild(XMLUtils.createElement((String)"currentLoginInMilliseconds", (Object)(this.getCurrentLogin().getTime() + ""), (Document)doc));
        }
        if (this.getAdded() != null) {
            userElement.appendChild(XMLUtils.createElement((String)"added", (Object)DateUtils.DATE_TIME_FORMATTER.format((Date)this.getAdded()), (Document)doc));
        }
        if (this.session != null && (sessionInfo = SessionUtils.getSessionInfoAsXML((HttpSession)this.session, (Document)doc)) != null) {
            userElement.appendChild(sessionInfo);
        }
        XMLUtils.appendNewElement((Document)doc, (Element)userElement, (String)"isMutable", (Object)(this instanceof MutableUser));
        XMLUtils.appendNewElement((Document)doc, (Element)userElement, (String)"hasFormProvider", (Object)this.hasFormProvider());
        XMLUtils.append((Document)doc, (Element)userElement, (String)"groups", this.getGroups());
        List<Element> additionalXML = this.getAdditionalXML(doc);
        if (!CollectionUtils.isEmpty(additionalXML)) {
            for (Element element : additionalXML) {
                userElement.appendChild(element);
            }
        }
        return userElement;
    }

    protected List<Element> getAdditionalXML(Document doc) {
        return null;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void valueBound(HttpSessionBindingEvent sessionBindingEvent) {
        if (sessionBindingEvent.getName().equals("user")) {
            this.session = sessionBindingEvent.getSession();
            this.userSingleton.addUser(this);
        }
    }

    public void valueUnbound(HttpSessionBindingEvent sessionBindingEvent) {
        if (LogManager.exists((String)CoreServlet.class.getName()) != null) {
            try {
                sessionBindingEvent.getSession().isNew();
            }
            catch (IllegalStateException e) {
                Logger.getLogger(this.getClass()).info((Object)("User " + this + " logged out by session timeout"));
            }
        }
        if (sessionBindingEvent.getName().equals("user")) {
            this.userSingleton.removeUser(this);
            this.session = null;
        }
    }

    public static ArrayList<User> getLoggedInUsers() {
        return UserSingleton.getInstance().getUsers();
    }

    protected final Object writeReplace() {
        if (!(this.session instanceof Serializable)) {
            this.session = null;
        }
        return this;
    }

    public int hashCode() {
        Integer userID = this.getUserID();
        int prime = 31;
        int result = 1;
        result = 31 * result + (userID == null ? super.hashCode() : userID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        Integer userID = this.getUserID();
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        Integer otherUserID = other.getUserID();
        return !(userID == null ? otherUserID != null : !userID.equals(otherUserID));
    }

    public abstract void setCurrentLogin(Timestamp var1);

    public AttributeHandler getAttributeHandler() {
        return null;
    }

    private static final class UserSingleton
    implements Serializable {
        private static final long serialVersionUID = 6039421779820047064L;
        private static UserSingleton userSingleton;
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final Lock r = this.readWriteLock.readLock();
        private final Lock w = this.readWriteLock.writeLock();
        private final ArrayList<User> loggedInUsers = new ArrayList();

        private UserSingleton() {
        }

        public static synchronized UserSingleton getInstance() {
            if (userSingleton == null) {
                userSingleton = new UserSingleton();
            }
            return userSingleton;
        }

        private Object readResolve() {
            if (userSingleton == null) {
                userSingleton = this;
            }
            return userSingleton;
        }

        private void addUser(User user) {
            try {
                this.w.lock();
                this.loggedInUsers.add(user);
            }
            finally {
                this.w.unlock();
            }
        }

        private void removeUser(User user) {
            try {
                this.w.lock();
                this.loggedInUsers.remove(user);
            }
            finally {
                this.w.unlock();
            }
        }

        public ArrayList<User> getUsers() {
            try {
                this.r.lock();
                ArrayList<User> arrayList = new ArrayList<User>(this.loggedInUsers);
                return arrayList;
            }
            finally {
                this.r.unlock();
            }
        }
    }
}

