/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.enums.HTTPProtocol;
import se.unlogic.hierarchy.core.handlers.SimpleMutableAttributeHandler;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.xml.XMLUtils;

public class SimpleSectionDescriptor
implements SectionDescriptor,
Serializable {
    private static final long serialVersionUID = 2062733982637464058L;
    private Integer sectionID = 0;
    private Integer parentSectionID;
    @WebPopulate(required=true, maxLength=255L)
    private String alias;
    private String fullAlias = "";
    @WebPopulate
    private HTTPProtocol requiredProtocol;
    @WebPopulate
    private boolean enabled;
    @WebPopulate
    private boolean anonymousAccess;
    @WebPopulate
    private boolean userAccess;
    @WebPopulate
    private boolean adminAccess;
    @WebPopulate
    private boolean visibleInMenu;
    @WebPopulate
    private boolean breadCrumb;
    @WebPopulate(required=true, maxLength=255L)
    private String name;
    @WebPopulate(required=true, maxLength=255L)
    private String description;
    @WebPopulate(maxLength=255L)
    private String anonymousDefaultURI;
    @WebPopulate(maxLength=255L)
    private String userDefaultURI;
    @WebPopulate(paramName="group")
    private List<Integer> allowedGroupIDs;
    @WebPopulate(paramName="user")
    private List<Integer> allowedUserIDs;
    private List<SimpleSectionDescriptor> subSectionsList;
    protected SimpleMutableAttributeHandler attributeHandler;

    @Override
    public Integer getSectionID() {
        return this.sectionID;
    }

    public void setSectionID(Integer sectionID) {
        this.sectionID = sectionID;
    }

    @Override
    public Integer getParentSectionID() {
        return this.parentSectionID;
    }

    public void setParentSectionID(Integer parentSectionID) {
        this.parentSectionID = parentSectionID;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public HTTPProtocol getRequiredProtocol() {
        return this.requiredProtocol;
    }

    public void setRequiredProtocol(HTTPProtocol requiredHTTPProtocol) {
        this.requiredProtocol = requiredHTTPProtocol;
    }

    @Override
    public String getFullAlias() {
        return this.fullAlias;
    }

    public void setFullAlias(String fullAlias) {
        this.fullAlias = fullAlias;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean allowsAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(boolean anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    @Override
    public boolean allowsUserAccess() {
        return this.userAccess;
    }

    public void setUserAccess(boolean userAccess) {
        this.userAccess = userAccess;
    }

    @Override
    public boolean allowsAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    @Override
    public boolean isVisibleInMenu() {
        return this.visibleInMenu;
    }

    public void setVisibleInMenu(boolean visibleInMenu) {
        this.visibleInMenu = visibleInMenu;
    }

    @Override
    public boolean hasBreadCrumb() {
        return this.breadCrumb;
    }

    public void setBreadCrumb(boolean breadCrumb) {
        this.breadCrumb = breadCrumb;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getAnonymousDefaultURI() {
        return this.anonymousDefaultURI;
    }

    public void setAnonymousDefaultURI(String anonymousDefaultURI) {
        this.anonymousDefaultURI = anonymousDefaultURI;
    }

    @Override
    public String getUserDefaultURI() {
        return this.userDefaultURI;
    }

    public void setUserDefaultURI(String userDefaultURI) {
        this.userDefaultURI = userDefaultURI;
    }

    @Override
    public List<SimpleSectionDescriptor> getSubSectionsList() {
        return this.subSectionsList;
    }

    public void setSubSectionsList(ArrayList<SimpleSectionDescriptor> subSectionsList) {
        this.subSectionsList = subSectionsList;
    }

    @Override
    public Element toXML(Document doc) {
        Element section = doc.createElement("section");
        if (this.sectionID != null) {
            section.appendChild(XMLUtils.createElement((String)"sectionID", (Object)this.sectionID.toString(), (Document)doc));
        }
        if (this.parentSectionID != null) {
            section.appendChild(XMLUtils.createElement((String)"parentSectionID", (Object)this.parentSectionID.toString(), (Document)doc));
        }
        if (this.alias != null) {
            section.appendChild(XMLUtils.createCDATAElement((String)"alias", (Object)this.alias, (Document)doc));
        }
        if (this.fullAlias != null) {
            section.appendChild(XMLUtils.createCDATAElement((String)"fullAlias", (Object)this.fullAlias, (Document)doc));
        }
        section.appendChild(XMLUtils.createElement((String)"enabled", (Object)Boolean.toString(this.enabled), (Document)doc));
        section.appendChild(XMLUtils.createElement((String)"anonymousAccess", (Object)Boolean.toString(this.anonymousAccess), (Document)doc));
        section.appendChild(XMLUtils.createElement((String)"userAccess", (Object)Boolean.toString(this.userAccess), (Document)doc));
        section.appendChild(XMLUtils.createElement((String)"adminAccess", (Object)Boolean.toString(this.adminAccess), (Document)doc));
        section.appendChild(XMLUtils.createElement((String)"visibleInMenu", (Object)Boolean.toString(this.visibleInMenu), (Document)doc));
        section.appendChild(XMLUtils.createElement((String)"breadCrumb", (Object)Boolean.toString(this.breadCrumb), (Document)doc));
        if (this.name != null) {
            section.appendChild(XMLUtils.createCDATAElement((String)"name", (Object)this.name, (Document)doc));
        }
        if (this.description != null) {
            section.appendChild(XMLUtils.createCDATAElement((String)"description", (Object)this.description, (Document)doc));
        }
        if (this.anonymousDefaultURI != null) {
            section.appendChild(XMLUtils.createCDATAElement((String)"anonymousDefaultURI", (Object)this.anonymousDefaultURI, (Document)doc));
        }
        if (this.userDefaultURI != null) {
            section.appendChild(XMLUtils.createCDATAElement((String)"userDefaultURI", (Object)this.userDefaultURI, (Document)doc));
        }
        if (this.requiredProtocol != null) {
            section.appendChild(XMLUtils.createCDATAElement((String)"requiredProtocol", (Object)((Object)this.requiredProtocol), (Document)doc));
        }
        if (this.attributeHandler != null) {
            section.appendChild(this.attributeHandler.toXML(doc));
        }
        AccessUtils.appendAllowedGroupAndUserIDs(doc, section, this);
        return section;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.fullAlias != null) {
            return this.name + " (ID: " + this.getSectionID() + ", alias: " + this.getFullAlias() + ")";
        }
        return this.name + " (ID: " + this.getSectionID() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sectionID == null ? 0 : this.sectionID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleSectionDescriptor other = (SimpleSectionDescriptor)obj;
        return !(this.sectionID == null ? other.sectionID != null : !this.sectionID.equals(other.sectionID));
    }

    public List<Integer> getAllowedGroupIDs() {
        return this.allowedGroupIDs;
    }

    public void setAllowedGroupIDs(List<Integer> allowedGroupIDs) {
        this.allowedGroupIDs = allowedGroupIDs;
    }

    public List<Integer> getAllowedUserIDs() {
        return this.allowedUserIDs;
    }

    public void setAllowedUserIDs(List<Integer> allowedUserIDs) {
        this.allowedUserIDs = allowedUserIDs;
    }

    @Override
    public SimpleMutableAttributeHandler getAttributeHandler() {
        if (this.attributeHandler == null) {
            this.attributeHandler = new SimpleMutableAttributeHandler(255, 4096);
        }
        return this.attributeHandler;
    }

    public void setAttributeHandler(SimpleMutableAttributeHandler attributeHandler) {
        this.attributeHandler = attributeHandler;
    }

    @Override
    public void saveAttributes(SystemInterface systemInterface) throws SQLException {
        systemInterface.getCoreDaoFactory().getSectionAttributeDAO().set(this);
    }
}

