/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.sql.SQLException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.BaseVisibleModuleDescriptor;
import se.unlogic.hierarchy.core.enums.HTTPProtocol;
import se.unlogic.hierarchy.core.enums.ModuleType;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.EnumPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.xml.XMLValidationUtils;

@Table(name="openhierarchy_foreground_modules")
public class SimpleForegroundModuleDescriptor
extends BaseVisibleModuleDescriptor
implements ForegroundModuleDescriptor {
    private static final long serialVersionUID = -979304448104554019L;
    @DAOManaged
    @WebPopulate(required=true, maxLength=45L)
    protected String alias;
    @DAOManaged
    @WebPopulate(required=true, maxLength=255L)
    protected String description;
    @DAOManaged
    @WebPopulate
    protected boolean visibleInMenu;
    @WebPopulate
    protected HTTPProtocol requiredProtocol;

    @Override
    public boolean isVisibleInMenu() {
        return this.visibleInMenu;
    }

    public void setVisibleInMenu(boolean visibleInMenu) {
        this.visibleInMenu = visibleInMenu;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public HTTPProtocol getRequiredProtocol() {
        return this.requiredProtocol;
    }

    public HTTPProtocol setRequiredProtocol(HTTPProtocol hTTPProtocol) {
        this.requiredProtocol = hTTPProtocol;
        return this.requiredProtocol;
    }

    @Override
    public Element toXML(Document doc) {
        Element moduleElement = super.toXML(doc);
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)moduleElement, (String)"description", (String)this.description);
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)moduleElement, (String)"alias", (String)this.alias);
        XMLUtils.appendNewElement((Document)doc, (Element)moduleElement, (String)"requiredProtocol", (Object)((Object)this.requiredProtocol));
        XMLUtils.appendNewElement((Document)doc, (Element)moduleElement, (String)"visibleInMenu", (Object)this.visibleInMenu);
        return moduleElement;
    }

    @Override
    public String toString() {
        return this.name + " (ID: " + this.moduleID + ", alias: " + this.alias + ")";
    }

    @Override
    public void saveSettings(SystemInterface systemInterface) throws SQLException {
        systemInterface.getCoreDaoFactory().getForegroundModuleSettingDAO().set(this);
    }

    @Override
    public void saveAttributes(SystemInterface systemInterface) throws SQLException {
        systemInterface.getCoreDaoFactory().getForegroundModuleAttributeDAO().set(this);
    }

    @Override
    public void populate(XMLParser xmlParser) throws ValidationException {
        ArrayList errors = null;
        try {
            super.populate(xmlParser);
        }
        catch (ValidationException e) {
            errors = e.getErrors();
        }
        if (errors == null) {
            errors = new ArrayList(2);
        }
        this.description = (String)XMLValidationUtils.validateParameter((String)"description", (XMLParser)xmlParser, (boolean)true, (Integer)1, (Integer)255, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.alias = (String)XMLValidationUtils.validateParameter((String)"alias", (XMLParser)xmlParser, (boolean)true, (Integer)1, (Integer)255, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.requiredProtocol = (HTTPProtocol)((Object)XMLValidationUtils.validateParameter((String)"requiredProtocol", (XMLParser)xmlParser, (boolean)false, (BeanStringPopulator)new EnumPopulator(HTTPProtocol.class), errors));
        this.visibleInMenu = xmlParser.getBoolean("visibleInMenu");
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    @Override
    public ModuleType getType() {
        return ModuleType.FOREGROUND;
    }
}

