/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.BaseModuleDescriptor;
import se.unlogic.hierarchy.core.enums.ModuleType;
import se.unlogic.hierarchy.core.interfaces.FilterModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.standardutils.annotations.NoDuplicates;
import se.unlogic.standardutils.annotations.SplitOnLineBreak;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.NonNegativeStringIntegerPopulator;
import se.unlogic.standardutils.populators.PositiveStringIntegerPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.xml.XMLValidationUtils;

@Table(name="openhierarchy_filter_modules")
public class SimpleFilterModuleDescriptor
extends BaseModuleDescriptor
implements FilterModuleDescriptor {
    private static final long serialVersionUID = -8158756503129841482L;
    @DAOManaged
    @WebPopulate(required=true, populator=NonNegativeStringIntegerPopulator.class)
    private int priority;
    @DAOManaged
    @OneToMany(autoAdd=true, autoUpdate=true, autoGet=true)
    @SimplifiedRelation(table="openhierarchy_filter_module_aliases", remoteKeyColumnName="moduleID", remoteValueColumnName="alias", preserveListOrder=true, indexColumn="listIndex")
    @WebPopulate(required=true, paramName="alias")
    @SplitOnLineBreak
    @NoDuplicates
    private List<String> aliases;

    @Override
    public void saveSettings(SystemInterface systemInterface) throws SQLException {
        systemInterface.getCoreDaoFactory().getFilterModuleSettingDAO().set(this);
    }

    @Override
    public void saveAttributes(SystemInterface systemInterface) throws SQLException {
        systemInterface.getCoreDaoFactory().getFilterModuleAttributeDAO().set(this);
    }

    @Override
    public Element toXML(Document doc) {
        Element moduleElement = super.toXML(doc);
        Element aliasElement = doc.createElement("aliases");
        moduleElement.appendChild(aliasElement);
        if (this.aliases != null) {
            for (String alias : this.aliases) {
                aliasElement.appendChild(XMLUtils.createCDATAElement((String)"alias", (Object)alias, (Document)doc));
            }
        }
        moduleElement.appendChild(XMLUtils.createElement((String)"priority", (Object)this.priority, (Document)doc));
        return moduleElement;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void populate(XMLParser xmlParser) throws ValidationException {
        ArrayList errors = null;
        try {
            super.populate(xmlParser);
        }
        catch (ValidationException e) {
            errors = e.getErrors();
        }
        if (errors == null) {
            errors = new ArrayList(2);
        }
        this.aliases = XMLValidationUtils.validateParameters((String)"aliases/alias", (XMLParser)xmlParser, (boolean)true, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.priority = (Integer)XMLValidationUtils.validateParameter((String)"priority", (XMLParser)xmlParser, (boolean)true, (BeanStringPopulator)PositiveStringIntegerPopulator.getPopulator(), errors);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    @Override
    public ModuleType getType() {
        return ModuleType.FILTER;
    }
}

