/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.DataSourceDescriptor;
import se.unlogic.hierarchy.core.enums.DataSourceType;
import se.unlogic.standardutils.annotations.RequiredIfSet;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;

@Table(name="openhierarchy_data_sources")
public class SimpleDataSourceDescriptor
implements Elementable,
DataSourceDescriptor {
    @DAOManaged(autoGenerated=true)
    @Key
    private Integer dataSourceID;
    @WebPopulate(required=true)
    @DAOManaged
    private DataSourceType type;
    @DAOManaged
    @WebPopulate(required=true, maxLength=255L)
    private String url;
    @DAOManaged
    @WebPopulate(maxLength=255L)
    private String defaultCatalog;
    @DAOManaged
    @WebPopulate(maxLength=255L)
    @RequiredIfSet(paramName="type", value="SystemManaged")
    private String driver;
    @DAOManaged
    @WebPopulate(required=true, maxLength=255L)
    private String name;
    @DAOManaged
    @WebPopulate(maxLength=255L)
    @RequiredIfSet(paramName="type", value="SystemManaged")
    private String username;
    @DAOManaged
    @WebPopulate(maxLength=255L)
    @RequiredIfSet(paramName="type", value="SystemManaged")
    private String password;
    @DAOManaged
    @WebPopulate
    private boolean enabled;
    @DAOManaged
    @WebPopulate
    private Boolean logAbandoned;
    @DAOManaged
    @WebPopulate
    private Boolean removeAbandoned;
    @DAOManaged
    @WebPopulate
    @RequiredIfSet(paramName="removeAbandoned")
    private Integer removeTimeout;
    @DAOManaged
    @WebPopulate
    private Boolean testOnBorrow;
    @DAOManaged
    @WebPopulate(maxLength=255L)
    @RequiredIfSet(paramName="testOnBorrow")
    private String validationQuery;
    @DAOManaged
    @WebPopulate
    @RequiredIfSet(paramName="type", value="SystemManaged")
    private Integer maxActive;
    @DAOManaged
    @WebPopulate
    @RequiredIfSet(paramName="type", value="SystemManaged")
    private Integer maxIdle;
    @DAOManaged
    @WebPopulate
    @RequiredIfSet(paramName="type", value="SystemManaged")
    private Integer minIdle;
    @DAOManaged
    @WebPopulate
    @RequiredIfSet(paramName="type", value="SystemManaged")
    private Integer maxWait;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SimpleDataSourceDescriptor() {
    }

    public SimpleDataSourceDescriptor(String url) {
        this.url = url;
        this.type = DataSourceType.ContainerManaged;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSourceID == null ? 0 : this.dataSourceID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleDataSourceDescriptor other = (SimpleDataSourceDescriptor)obj;
        return !(this.dataSourceID == null ? other.dataSourceID != null : !this.dataSourceID.equals(other.dataSourceID));
    }

    @Override
    public Integer getDataSourceID() {
        return this.dataSourceID;
    }

    public void setDataSourceID(Integer datasourceID) {
        this.dataSourceID = datasourceID;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public DataSourceType getType() {
        return this.type;
    }

    public void setType(DataSourceType type) {
        this.type = type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return this.url + " (ID: " + this.dataSourceID + ", " + (Object)((Object)this.type) + ")";
    }

    @Override
    public boolean removeAbandoned() {
        if (this.removeAbandoned == null) {
            return false;
        }
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    @Override
    public Integer getRemoveTimeout() {
        return this.removeTimeout;
    }

    public void setRemoveTimeout(Integer removeTimeout) {
        this.removeTimeout = removeTimeout;
    }

    @Override
    public boolean testOnBorrow() {
        if (this.testOnBorrow == null) {
            return false;
        }
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    @Override
    public Integer getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
    }

    @Override
    public Integer getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public Integer getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public boolean logAbandoned() {
        if (this.logAbandoned == null) {
            return false;
        }
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    @Override
    public Integer getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public Element toXML(Document doc) {
        Element datasource = doc.createElement("datasource");
        datasource.appendChild(XMLUtils.createElement((String)"dataSourceID", (Object)this.dataSourceID.toString(), (Document)doc));
        datasource.appendChild(XMLUtils.createCDATAElement((String)"url", (Object)this.url.toString(), (Document)doc));
        datasource.appendChild(XMLUtils.createElement((String)"type", (Object)this.type.toString(), (Document)doc));
        datasource.appendChild(XMLUtils.createElement((String)"enabled", (Object)Boolean.toString(this.enabled), (Document)doc));
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"name", (String)this.name);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"driver", (String)this.driver);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"username", (String)this.username);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"password", (String)this.password);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"defaultCatalog", (String)this.defaultCatalog);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"logAbandoned", (Object)this.logAbandoned);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"removeAbandoned", (Object)this.removeAbandoned);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"removeTimeout", (Object)this.removeTimeout);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"testOnBorrow", (Object)this.testOnBorrow);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"validationQuery", (String)this.validationQuery);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"maxActive", (Object)this.maxActive);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"maxIdle", (Object)this.maxIdle);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"minIdle", (Object)this.minIdle);
        XMLUtils.appendNewElement((Document)doc, (Element)datasource, (String)"maxWait", (Object)this.maxWait);
        return datasource;
    }
}

