/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.BaseVisibleModuleDescriptor;
import se.unlogic.hierarchy.core.enums.ModuleType;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.standardutils.annotations.NoDuplicates;
import se.unlogic.standardutils.annotations.SplitOnLineBreak;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.NonNegativeStringIntegerPopulator;
import se.unlogic.standardutils.populators.PositiveStringIntegerPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.xml.XMLValidationUtils;

@Table(name="openhierarchy_background_modules")
public class SimpleBackgroundModuleDescriptor
extends BaseVisibleModuleDescriptor
implements BackgroundModuleDescriptor {
    private static final long serialVersionUID = -2949709405791503907L;
    @DAOManaged
    @OneToMany(autoAdd=true, autoUpdate=true, autoGet=true)
    @SimplifiedRelation(table="openhierarchy_background_module_aliases", remoteKeyColumnName="moduleID", remoteValueColumnName="alias", preserveListOrder=true, indexColumn="listIndex")
    @WebPopulate(required=true, paramName="alias")
    @SplitOnLineBreak
    @NoDuplicates
    private List<String> aliases;
    @DAOManaged
    @OneToMany(autoAdd=true, autoUpdate=true, autoGet=true)
    @SimplifiedRelation(table="openhierarchy_background_module_slots", remoteKeyColumnName="moduleID", remoteValueColumnName="slot")
    @WebPopulate(paramName="slots")
    @SplitOnLineBreak
    @NoDuplicates
    private List<String> slots;
    @DAOManaged
    @WebPopulate(required=true, populator=NonNegativeStringIntegerPopulator.class)
    private int priority;

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public List<String> getSlots() {
        return this.slots;
    }

    public void setSlots(List<String> slots) {
        this.slots = slots;
    }

    @Override
    public Element toXML(Document doc) {
        Element moduleElement = super.toXML(doc);
        Element aliasElement = doc.createElement("aliases");
        moduleElement.appendChild(aliasElement);
        for (String alias : this.aliases) {
            aliasElement.appendChild(XMLUtils.createCDATAElement((String)"alias", (Object)alias, (Document)doc));
        }
        if (!CollectionUtils.isEmpty(this.slots)) {
            Element slotsElement = doc.createElement("slots");
            moduleElement.appendChild(slotsElement);
            for (String slot : this.slots) {
                slotsElement.appendChild(XMLUtils.createCDATAElement((String)"slot", (Object)slot, (Document)doc));
            }
        }
        moduleElement.appendChild(XMLUtils.createElement((String)"priority", (Object)this.priority, (Document)doc));
        return moduleElement;
    }

    @Override
    public void saveSettings(SystemInterface systemInterface) throws SQLException {
        systemInterface.getCoreDaoFactory().getBackgroundModuleSettingDAO().set(this);
    }

    @Override
    public void saveAttributes(SystemInterface systemInterface) throws SQLException {
        systemInterface.getCoreDaoFactory().getBackgroundModuleAttributeDAO().set(this);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void populate(XMLParser xmlParser) throws ValidationException {
        ArrayList errors = null;
        try {
            super.populate(xmlParser);
        }
        catch (ValidationException e) {
            errors = e.getErrors();
        }
        if (errors == null) {
            errors = new ArrayList(2);
        }
        this.aliases = XMLValidationUtils.validateParameters((String)"aliases/alias", (XMLParser)xmlParser, (boolean)true, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.slots = XMLValidationUtils.validateParameters((String)"slots/slot", (XMLParser)xmlParser, (boolean)true, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.priority = (Integer)XMLValidationUtils.validateParameter((String)"priority", (XMLParser)xmlParser, (boolean)true, (BeanStringPopulator)PositiveStringIntegerPopulator.getPopulator(), errors);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    @Override
    public ModuleType getType() {
        return ModuleType.BACKGROUND;
    }
}

