/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import se.unlogic.hierarchy.core.interfaces.AccessInterface;
import se.unlogic.standardutils.collections.CollectionUtils;

public class SimpleAccessInterface
implements AccessInterface,
Serializable {
    private static final long serialVersionUID = 8999001518585792348L;
    private boolean adminAccess;
    private boolean anonymousAccess;
    private boolean userAccess;
    private Collection<Integer> allowedGroupIDs;
    private Collection<Integer> allowedUserIDs;

    public SimpleAccessInterface(Collection<Integer> allowedGroupIDs, Collection<Integer> allowedUserIDs) {
        this.allowedGroupIDs = allowedGroupIDs;
        this.allowedUserIDs = allowedUserIDs;
    }

    public SimpleAccessInterface(boolean adminAccess, boolean anonymousAccess, boolean userAccess) {
        this.adminAccess = adminAccess;
        this.anonymousAccess = anonymousAccess;
        this.userAccess = userAccess;
    }

    public SimpleAccessInterface(boolean adminAccess, boolean anonymousAccess, boolean userAccess, Collection<Integer> allowedGroupIDs, Collection<Integer> allowedUserIDs) {
        this.adminAccess = adminAccess;
        this.anonymousAccess = anonymousAccess;
        this.userAccess = userAccess;
        this.allowedGroupIDs = allowedGroupIDs;
        this.allowedUserIDs = allowedUserIDs;
    }

    public SimpleAccessInterface(AccessInterface accessInterface) {
        this.adminAccess = accessInterface.allowsAdminAccess();
        this.userAccess = accessInterface.allowsUserAccess();
        this.anonymousAccess = accessInterface.allowsAnonymousAccess();
        if (!CollectionUtils.isEmpty(accessInterface.getAllowedUserIDs())) {
            this.allowedUserIDs = !(accessInterface.getAllowedUserIDs() instanceof Serializable) ? new ArrayList<Integer>(accessInterface.getAllowedUserIDs()) : accessInterface.getAllowedUserIDs();
        }
        if (!CollectionUtils.isEmpty(accessInterface.getAllowedGroupIDs())) {
            this.allowedGroupIDs = !(accessInterface.getAllowedGroupIDs() instanceof Serializable) ? new ArrayList<Integer>(accessInterface.getAllowedGroupIDs()) : accessInterface.getAllowedGroupIDs();
        }
    }

    @Override
    public boolean allowsAdminAccess() {
        return this.adminAccess;
    }

    @Override
    public boolean allowsAnonymousAccess() {
        return this.anonymousAccess;
    }

    @Override
    public boolean allowsUserAccess() {
        return this.userAccess;
    }

    @Override
    public Collection<Integer> getAllowedGroupIDs() {
        return this.allowedGroupIDs;
    }

    @Override
    public Collection<Integer> getAllowedUserIDs() {
        return this.allowedUserIDs;
    }
}

