/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.MenuItem;
import se.unlogic.hierarchy.core.beans.SectionMenu;
import se.unlogic.hierarchy.core.enums.MenuItemType;
import se.unlogic.hierarchy.core.enums.URLType;
import se.unlogic.standardutils.xml.XMLUtils;

public class SectionMenuItem
extends MenuItem
implements Cloneable {
    protected SectionMenu sectionMenu;
    private Integer subSectionID;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subSectionID == null ? 0 : this.subSectionID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SectionMenuItem other = (SectionMenuItem)obj;
        return !(this.subSectionID == null ? other.subSectionID != null : !this.subSectionID.equals(other.subSectionID));
    }

    public SectionMenuItem() {
        this.itemType = MenuItemType.SECTION;
    }

    public void setSubSectionID(Integer subSectionID) {
        this.subSectionID = subSectionID;
    }

    public Integer getSubSectionID() {
        return this.subSectionID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setMenuIndex(Integer menuIndex) {
        this.menuIndex = menuIndex;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUrlType(URLType urlType) {
        this.urlType = urlType;
    }

    public void setSectionID(Integer sectionID) {
        this.sectionID = sectionID;
    }

    public void setAdminAccess(boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public void setAnonymousAccess(boolean anonumousAccess) {
        this.anonymousAccess = anonumousAccess;
    }

    public void setUserAccess(boolean userAccess) {
        this.userAccess = userAccess;
    }

    public void setAllowedGroupIDs(Collection<Integer> allowedGroupIDs) {
        this.allowedGroupIDs = allowedGroupIDs;
    }

    public void setAllowedUserIDs(Collection<Integer> allowedUserIDs) {
        this.allowedUserIDs = allowedUserIDs;
    }

    @Override
    protected void getAdditionalXML(Document doc, Element menuItemElement) {
        Element sectionMenuItemElement = doc.createElement("sectionMenuItem");
        sectionMenuItemElement.appendChild(XMLUtils.createCDATAElement((String)"subSectionID", (Object)this.subSectionID.toString(), (Document)doc));
        menuItemElement.appendChild(sectionMenuItemElement);
        if (this.sectionMenu != null) {
            menuItemElement.appendChild(this.sectionMenu.toXML(doc));
        }
    }

    public MenuItem clone(SectionMenu subMenu, boolean selected) {
        try {
            SectionMenuItem clone = (SectionMenuItem)this.clone();
            clone.sectionMenu = subMenu;
            if (selected) {
                clone.selected = true;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

