/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.MenuItem;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;

public class SectionMenu {
    private final SectionDescriptor sectionDescriptor;
    private final ArrayList<MenuItem> menuItems;

    public SectionMenu(ArrayList<MenuItem> menuItems, SectionDescriptor sectionDescriptor) {
        this.menuItems = menuItems;
        this.sectionDescriptor = sectionDescriptor;
    }

    public Element toXML(Document doc) {
        Element menuitems = doc.createElement("menu");
        menuitems.setAttribute("sectionID", this.sectionDescriptor.getSectionID().toString());
        menuitems.setAttribute("sectionName", this.sectionDescriptor.getName());
        menuitems.setAttribute("sectionAlias", this.sectionDescriptor.getFullAlias());
        for (MenuItem menuItem : this.menuItems) {
            menuitems.appendChild(menuItem.toXML(doc));
        }
        return menuitems;
    }

    public Integer getSectionID() {
        return this.sectionDescriptor.getSectionID();
    }

    public ArrayList<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public SectionDescriptor getSectionDescriptor() {
        return this.sectionDescriptor;
    }
}

