/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.MenuItem;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MenuItemDescriptor;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;

public class ModuleMenuItem
extends MenuItem
implements Elementable {
    private final Integer moduleID;
    private String uniqueID;
    private final boolean bundled;

    public ModuleMenuItem(MenuItemDescriptor menuItemDescriptor, ForegroundModuleDescriptor descriptor, boolean bundled) {
        this.name = menuItemDescriptor.getName();
        this.description = menuItemDescriptor.getDescription();
        this.url = menuItemDescriptor.getUrl();
        this.urlType = menuItemDescriptor.getUrlType();
        this.itemType = menuItemDescriptor.getItemType();
        this.allowedGroupIDs = menuItemDescriptor.getAllowedGroupIDs();
        this.allowedUserIDs = menuItemDescriptor.getAllowedUserIDs();
        this.adminAccess = menuItemDescriptor.allowsAdminAccess();
        this.userAccess = menuItemDescriptor.allowsUserAccess();
        this.anonymousAccess = menuItemDescriptor.allowsAnonymousAccess();
        this.uniqueID = menuItemDescriptor.getUniqueID();
        this.sectionID = descriptor.getSectionID();
        this.bundled = bundled;
        this.moduleID = descriptor.getModuleID() != null ? descriptor.getModuleID() : menuItemDescriptor.getModuleID();
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public Integer getModuleID() {
        return this.moduleID;
    }

    @Override
    public void setMenuIndex(Integer menuIndex) {
        this.menuIndex = menuIndex;
    }

    @Override
    protected void getAdditionalXML(Document doc, Element menuItemElement) {
        Element moduleMenuItemElement = doc.createElement("moduleMenuItem");
        moduleMenuItemElement.appendChild(XMLUtils.createCDATAElement((String)"moduleID", (Object)this.moduleID.toString(), (Document)doc));
        if (this.uniqueID != null) {
            moduleMenuItemElement.appendChild(XMLUtils.createCDATAElement((String)"uniqueID", (Object)this.uniqueID.toString(), (Document)doc));
        }
        menuItemElement.appendChild(moduleMenuItemElement);
        if (this.bundled) {
            menuItemElement.setAttribute("bundled", "true");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moduleID == null ? 0 : this.moduleID.hashCode());
        result = 31 * result + (this.uniqueID == null ? 0 : this.uniqueID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleMenuItem other = (ModuleMenuItem)obj;
        if (this.moduleID == null ? other.moduleID != null : !this.moduleID.equals(other.moduleID)) {
            return false;
        }
        return !(this.uniqueID == null ? other.uniqueID != null : !this.uniqueID.equals(other.uniqueID));
    }
}

