/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.enums.MenuItemType;
import se.unlogic.hierarchy.core.enums.URLType;
import se.unlogic.hierarchy.core.interfaces.AccessInterface;
import se.unlogic.standardutils.xml.XMLUtils;

public abstract class MenuItem
implements AccessInterface,
Cloneable {
    protected String name;
    protected String description;
    protected Integer menuIndex;
    protected String url;
    protected URLType urlType;
    protected MenuItemType itemType;
    protected Integer sectionID;
    protected boolean anonymousAccess;
    protected boolean userAccess;
    protected boolean adminAccess;
    protected Collection<Integer> allowedGroupIDs;
    protected Collection<Integer> allowedUserIDs;
    protected boolean selected;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getMenuIndex() {
        return this.menuIndex;
    }

    public void setMenuIndex(Integer menuIndex) {
        this.menuIndex = menuIndex;
    }

    public String getUrl() {
        return this.url;
    }

    public MenuItemType getItemType() {
        return this.itemType;
    }

    public URLType getUrlType() {
        return this.urlType;
    }

    public Integer getSectionID() {
        return this.sectionID;
    }

    @Override
    public boolean allowsAdminAccess() {
        return this.adminAccess;
    }

    @Override
    public boolean allowsAnonymousAccess() {
        return this.anonymousAccess;
    }

    @Override
    public boolean allowsUserAccess() {
        return this.userAccess;
    }

    @Override
    public Collection<Integer> getAllowedGroupIDs() {
        return this.allowedGroupIDs;
    }

    @Override
    public Collection<Integer> getAllowedUserIDs() {
        return this.allowedUserIDs;
    }

    public final Element toXML(Document doc) {
        Element menuItemElement = doc.createElement("menuitem");
        if (this.name != null) {
            menuItemElement.appendChild(XMLUtils.createCDATAElement((String)"name", (Object)this.name, (Document)doc));
        }
        if (this.description != null) {
            menuItemElement.appendChild(XMLUtils.createCDATAElement((String)"description", (Object)this.description, (Document)doc));
        }
        if (this.menuIndex != null) {
            menuItemElement.appendChild(XMLUtils.createCDATAElement((String)"menuIndex", (Object)this.menuIndex.toString(), (Document)doc));
        }
        if (this.url != null) {
            menuItemElement.appendChild(XMLUtils.createCDATAElement((String)"url", (Object)this.url, (Document)doc));
        }
        if (this.urlType != null) {
            menuItemElement.appendChild(XMLUtils.createCDATAElement((String)"urlType", (Object)this.urlType.toString(), (Document)doc));
        }
        if (this.itemType != null) {
            menuItemElement.appendChild(XMLUtils.createCDATAElement((String)"itemType", (Object)this.itemType.toString(), (Document)doc));
        }
        if (this.sectionID != null) {
            menuItemElement.appendChild(XMLUtils.createCDATAElement((String)"sectionID", (Object)this.sectionID.toString(), (Document)doc));
        }
        Element adminAccess = doc.createElement("adminAccess");
        adminAccess.appendChild(doc.createTextNode(Boolean.toString(this.adminAccess)));
        menuItemElement.appendChild(adminAccess);
        Element userAccess = doc.createElement("userAccess");
        userAccess.appendChild(doc.createTextNode(Boolean.toString(this.userAccess)));
        menuItemElement.appendChild(userAccess);
        Element anonymousAccess = doc.createElement("anonymousAccess");
        anonymousAccess.appendChild(doc.createTextNode(Boolean.toString(this.anonymousAccess)));
        menuItemElement.appendChild(anonymousAccess);
        this.getAdditionalXML(doc, menuItemElement);
        if (this.selected) {
            menuItemElement.appendChild(doc.createElement("selected"));
        }
        return menuItemElement;
    }

    protected void getAdditionalXML(Document doc, Element menuItem) {
    }

    public String toString() {
        return this.name;
    }

    public MenuItem getSelectedClone() {
        MenuItem clone;
        try {
            clone = (MenuItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.selected = true;
        return clone;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

