/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.MutableGroup;
import se.unlogic.hierarchy.core.interfaces.AttributeHandler;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;

public abstract class Group
implements Serializable,
Elementable {
    private static final long serialVersionUID = -3034316839387156132L;

    public abstract Integer getGroupID();

    public abstract String getName();

    public abstract String getDescription();

    public abstract boolean isEnabled();

    public final Element toXML(Document doc) {
        Element groupElement = doc.createElement("group");
        if (this.getGroupID() != null) {
            groupElement.appendChild(XMLUtils.createCDATAElement((String)"groupID", (Object)this.getGroupID().toString(), (Document)doc));
        }
        if (this.getName() != null) {
            groupElement.appendChild(XMLUtils.createCDATAElement((String)"name", (Object)this.getName(), (Document)doc));
        }
        if (this.getDescription() != null) {
            groupElement.appendChild(XMLUtils.createCDATAElement((String)"description", (Object)this.getDescription(), (Document)doc));
        }
        groupElement.appendChild(XMLUtils.createCDATAElement((String)"enabled", (Object)Boolean.toString(this.isEnabled()), (Document)doc));
        List<Element> additionalXML = this.getAdditionalXML(doc);
        if (!CollectionUtils.isEmpty(additionalXML)) {
            for (Element element : additionalXML) {
                groupElement.appendChild(element);
            }
        }
        XMLUtils.appendNewElement((Document)doc, (Element)groupElement, (String)"isMutable", (Object)(this instanceof MutableGroup));
        return groupElement;
    }

    protected List<Element> getAdditionalXML(Document doc) {
        return null;
    }

    public int hashCode() {
        Integer groupID = this.getGroupID();
        int prime = 31;
        int result = 1;
        result = 31 * result + (groupID == null ? super.hashCode() : groupID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        Integer groupID = this.getGroupID();
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        Integer otherGroupID = other.getGroupID();
        return !(groupID == null ? otherGroupID != null : !groupID.equals(otherGroupID));
    }

    public AttributeHandler getAttributeHandler() {
        return null;
    }
}

