/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.cache.DataSourceCache;
import se.unlogic.hierarchy.core.enums.DataSourceStatus;
import se.unlogic.hierarchy.core.exceptions.DataSourceDeletedException;
import se.unlogic.hierarchy.core.exceptions.DataSourceException;

public class DataSourceWrapper
implements DataSource {
    private DataSource dataSource;
    private DataSourceCache dataSourceCache;
    private int dataSourceID;
    private boolean deleted;

    public DataSourceWrapper(DataSource dataSource, DataSourceCache dataSourceCache, int dataSourceID) {
        this.dataSource = dataSource;
        this.dataSourceCache = dataSourceCache;
        this.dataSourceID = dataSourceID;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.deleted) {
            throw new DataSourceDeletedException();
        }
        this.dataSource = dataSource;
    }

    public void stop() {
        this.dataSource = null;
    }

    public void delete() {
        if (this.deleted) {
            throw new DataSourceDeletedException();
        }
        this.deleted = true;
        this.dataSource = null;
        this.dataSourceCache = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    public DataSource getDataSource() {
        if (this.deleted) {
            throw new DataSourceDeletedException();
        }
        DataSource dataSource = this.dataSource;
        if (dataSource == null) {
            try {
                this.dataSourceCache.getDataSource(this.dataSourceID);
            }
            catch (DataSourceException e) {
                throw new RuntimeException(e);
            }
            dataSource = this.dataSource;
            if (dataSource == null) {
                throw new IllegalStateException("Unable to get new instance of stopped datasource");
            }
        }
        return dataSource;
    }

    public String toString() {
        return "Wrapping datasource: " + this.dataSource;
    }

    public DataSourceStatus getDataSourceStatus() {
        if (this.dataSource != null) {
            return DataSourceStatus.CACHED;
        }
        if (this.deleted) {
            return DataSourceStatus.DELETED;
        }
        return DataSourceStatus.STOPPED;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }
}

