/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.MenuItem;
import se.unlogic.hierarchy.core.beans.ModuleMenuItem;
import se.unlogic.hierarchy.core.interfaces.BundleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MenuItemDescriptor;
import se.unlogic.standardutils.xml.XMLUtils;

public class Bundle
extends MenuItem
implements Cloneable {
    private final Integer moduleID;
    private String uniqueID;
    private ArrayList<ModuleMenuItem> moduleMenuItems;

    public Bundle(BundleDescriptor bundleDescriptor, ForegroundModuleDescriptor descriptor) {
        this.name = bundleDescriptor.getName();
        this.description = bundleDescriptor.getDescription();
        this.url = bundleDescriptor.getUrl();
        this.urlType = bundleDescriptor.getUrlType();
        this.itemType = bundleDescriptor.getItemType();
        this.allowedGroupIDs = bundleDescriptor.getAllowedGroupIDs();
        this.allowedUserIDs = bundleDescriptor.getAllowedUserIDs();
        this.adminAccess = bundleDescriptor.allowsAdminAccess();
        this.userAccess = bundleDescriptor.allowsUserAccess();
        this.anonymousAccess = bundleDescriptor.allowsAnonymousAccess();
        this.moduleMenuItems = new ArrayList();
        if (bundleDescriptor.getMenuItemDescriptors() != null) {
            List<? extends MenuItemDescriptor> tempMenuItemDescriptors = bundleDescriptor.getMenuItemDescriptors();
            for (MenuItemDescriptor menuItemDescriptor : tempMenuItemDescriptors) {
                this.moduleMenuItems.add(new ModuleMenuItem(menuItemDescriptor, descriptor, true));
            }
        }
        this.sectionID = descriptor.getSectionID();
        this.moduleID = descriptor.getModuleID();
        this.uniqueID = bundleDescriptor.getUniqueID();
    }

    public ArrayList<ModuleMenuItem> getModuleMenuItems() {
        return this.moduleMenuItems;
    }

    public Integer getModuleID() {
        return this.moduleID;
    }

    @Override
    public void setMenuIndex(Integer menuIndex) {
        this.menuIndex = menuIndex;
    }

    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    @Override
    protected void getAdditionalXML(Document doc, Element menuItemElement) {
        Element bundleElement = doc.createElement("bundle");
        bundleElement.appendChild(XMLUtils.createCDATAElement((String)"moduleID", (Object)this.moduleID.toString(), (Document)doc));
        bundleElement.appendChild(XMLUtils.createCDATAElement((String)"uniqueID", (Object)this.uniqueID, (Document)doc));
        menuItemElement.appendChild(bundleElement);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moduleID == null ? 0 : this.moduleID.hashCode());
        result = 31 * result + (this.uniqueID == null ? 0 : this.uniqueID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bundle other = (Bundle)obj;
        if (this.moduleID == null ? other.moduleID != null : !this.moduleID.equals(other.moduleID)) {
            return false;
        }
        return !(this.uniqueID == null ? other.uniqueID != null : !this.uniqueID.equals(other.uniqueID));
    }

    public Bundle clone() {
        try {
            Bundle bundle = (Bundle)super.clone();
            bundle.moduleMenuItems = new ArrayList<ModuleMenuItem>(this.moduleMenuItems);
            return bundle;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Element toFullXML(Document doc) {
        Element bundleElement = doc.createElement("bundle");
        bundleElement.appendChild(XMLUtils.createCDATAElement((String)"moduleID", (Object)this.moduleID.toString(), (Document)doc));
        if (this.name != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"name", (Object)this.name, (Document)doc));
        }
        if (this.description != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"description", (Object)this.description, (Document)doc));
        }
        if (this.menuIndex != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"menuIndex", (Object)this.menuIndex.toString(), (Document)doc));
        }
        if (this.url != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"url", (Object)this.url, (Document)doc));
        }
        if (this.urlType != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"urlType", (Object)this.urlType.toString(), (Document)doc));
        }
        if (this.itemType != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"itemType", (Object)this.itemType.toString(), (Document)doc));
        }
        if (this.sectionID != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"sectionID", (Object)this.sectionID.toString(), (Document)doc));
        }
        if (this.uniqueID != null) {
            bundleElement.appendChild(XMLUtils.createCDATAElement((String)"uniqueID", (Object)this.uniqueID.toString(), (Document)doc));
        }
        Element adminAccess = doc.createElement("adminAccess");
        adminAccess.appendChild(doc.createTextNode(Boolean.toString(this.adminAccess)));
        bundleElement.appendChild(adminAccess);
        Element userAccess = doc.createElement("userAccess");
        userAccess.appendChild(doc.createTextNode(Boolean.toString(this.userAccess)));
        bundleElement.appendChild(userAccess);
        Element anonymousAccess = doc.createElement("anonymousAccess");
        anonymousAccess.appendChild(doc.createTextNode(Boolean.toString(this.anonymousAccess)));
        bundleElement.appendChild(anonymousAccess);
        XMLUtils.append((Document)doc, (Element)bundleElement, (String)"menuitems", this.moduleMenuItems);
        return bundleElement;
    }
}

