/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.enums.URLType;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.hierarchy.foregroundmodules.SimpleForegroundModule;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;

public class Breadcrumb {
    private final String name;
    private final String description;
    private final String url;
    private final URLType urlType;

    public Breadcrumb(String name) {
        this.name = name;
        this.description = name;
        this.url = null;
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(String name, String url) {
        this.name = name;
        this.description = name;
        this.url = url;
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(String name, String description, String url) {
        this.name = name;
        this.description = description;
        this.url = url;
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(String name, String url, URLType urlType) {
        this.name = name;
        this.description = name;
        this.url = url;
        this.urlType = urlType;
        this.validate();
    }

    public Breadcrumb(String name, String description, String url, URLType urlType) {
        this.name = name;
        this.description = description;
        this.url = url;
        this.urlType = urlType;
        this.validate();
    }

    public Breadcrumb(SectionDescriptor sectionDescriptor, ForegroundModuleDescriptor moduleDescriptor) {
        this.name = moduleDescriptor.getName();
        this.description = moduleDescriptor.getDescription();
        this.url = sectionDescriptor.getFullAlias() + "/" + moduleDescriptor.getAlias();
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(SimpleForegroundModule foregroundModule, String name, String description, String additionalAlias) {
        this.name = name;
        this.description = description;
        this.url = foregroundModule.getFullAlias() + additionalAlias;
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(SimpleForegroundModule foregroundModule, String name, String additionalAlias) {
        this.name = name;
        this.description = name;
        this.url = foregroundModule.getFullAlias() + additionalAlias;
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(AnnotatedForegroundModule foregroundModule, String name, String description, String additionalAlias) {
        this.name = name;
        this.description = description;
        this.url = foregroundModule.getFullAlias() + additionalAlias;
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(AnnotatedForegroundModule foregroundModule, String name, String additionalAlias) {
        this.name = name;
        this.description = name;
        this.url = foregroundModule.getFullAlias() + additionalAlias;
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    public Breadcrumb(SectionDescriptor sectionDescriptor) {
        this.name = sectionDescriptor.getName();
        this.description = sectionDescriptor.getDescription();
        this.url = !StringUtils.isEmpty((String)sectionDescriptor.getFullAlias()) ? sectionDescriptor.getFullAlias() : "/";
        this.urlType = URLType.RELATIVE_FROM_CONTEXTPATH;
        this.validate();
    }

    private void validate() {
        if (this.url != null && this.urlType == null) {
            throw new NullPointerException("URLType cannot be null if url is set!");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public URLType getUrlType() {
        return this.urlType;
    }

    public Element toXML(Document doc) {
        Element breadcrumbElement = doc.createElement("breadcrumb");
        XMLUtils.appendNewCDATAElement((Document)doc, (Element)breadcrumbElement, (String)"name", (String)StringUtils.substring((String)this.name, (int)40, (String)"..."));
        if (this.description != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)breadcrumbElement, (String)"description", (String)this.description);
        }
        if (this.url != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)breadcrumbElement, (String)"url", (String)this.url);
        }
        if (this.urlType != null) {
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)breadcrumbElement, (String)"urlType", (Object)((Object)this.urlType));
        }
        return breadcrumbElement;
    }
}

