/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.BaseModuleDescriptor;
import se.unlogic.hierarchy.core.enums.PathType;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.EnumPopulator;
import se.unlogic.standardutils.populators.PositiveStringIntegerPopulator;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.xml.XMLValidationUtils;

public abstract class BaseVisibleModuleDescriptor
extends BaseModuleDescriptor {
    private static final long serialVersionUID = 7287756341751909759L;
    @DAOManaged
    protected Integer sectionID;
    @DAOManaged
    @WebPopulate(maxLength=255L)
    protected String xslPath;
    @DAOManaged
    @WebPopulate
    protected PathType xslPathType;
    @DAOManaged
    @WebPopulate(maxLength=255L)
    protected String staticContentPackage;

    public Integer getSectionID() {
        return this.sectionID;
    }

    public void setSectionID(Integer section) {
        this.sectionID = section;
    }

    public String getStaticContentPackage() {
        return this.staticContentPackage;
    }

    public void setStaticContentPackage(String staticContentPackage) {
        this.staticContentPackage = staticContentPackage;
    }

    public String getXslPath() {
        return this.xslPath;
    }

    public void setXslPath(String xslPath) {
        this.xslPath = xslPath;
    }

    public PathType getXslPathType() {
        return this.xslPathType;
    }

    public void setXslPathType(PathType xslPathType) {
        this.xslPathType = xslPathType;
    }

    public boolean hasStyleSheet() {
        if (this.getXslPath() != null && this.getXslPathType() != null) {
            if (this.getXslPathType() == PathType.Filesystem) {
                return true;
            }
            if (this.getXslPathType() == PathType.RealtiveFilesystem) {
                return true;
            }
            if (this.getXslPathType() == PathType.Classpath) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Element toXML(Document doc) {
        Element moduleElement = super.toXML(doc);
        if (this.sectionID != null) {
            moduleElement.appendChild(XMLUtils.createElement((String)"sectionID", (Object)this.sectionID.toString(), (Document)doc));
        }
        if (this.xslPath != null) {
            moduleElement.appendChild(XMLUtils.createElement((String)"xslPath", (Object)this.xslPath, (Document)doc));
        }
        if (this.xslPathType != null) {
            moduleElement.appendChild(XMLUtils.createElement((String)"xslPathType", (Object)this.xslPathType.toString(), (Document)doc));
        }
        if (this.staticContentPackage != null) {
            moduleElement.appendChild(XMLUtils.createCDATAElement((String)"staticContentPackage", (Object)this.staticContentPackage, (Document)doc));
        }
        return moduleElement;
    }

    @Override
    public void populate(XMLParser xmlParser) throws ValidationException {
        ArrayList errors = null;
        try {
            super.populate(xmlParser);
        }
        catch (ValidationException e) {
            errors = e.getErrors();
        }
        if (errors == null) {
            errors = new ArrayList(2);
        }
        this.sectionID = (Integer)XMLValidationUtils.validateParameter((String)"sectionID", (XMLParser)xmlParser, (boolean)true, (BeanStringPopulator)PositiveStringIntegerPopulator.getPopulator(), errors);
        this.staticContentPackage = xmlParser.getString("staticContentPackage");
        this.xslPathType = (PathType)((Object)XMLValidationUtils.validateParameter((String)"xslPathType", (XMLParser)xmlParser, (boolean)false, (BeanStringPopulator)new EnumPopulator(PathType.class), errors));
        this.xslPath = xmlParser.getString("xslPath");
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }
}

