/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.handlers.SimpleMutableAttributeHandler;
import se.unlogic.hierarchy.core.handlers.SimpleSettingHandler;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OneToMany;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.SimplifiedRelation;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLParserPopulateable;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.xml.XMLValidationUtils;

public abstract class BaseModuleDescriptor
implements ModuleDescriptor,
XMLParserPopulateable {
    private static final long serialVersionUID = -420170467834032478L;
    @DAOManaged(autoGenerated=true)
    @Key
    protected Integer moduleID;
    @DAOManaged
    @WebPopulate(required=true, maxLength=255L)
    protected String classname;
    @DAOManaged
    @OrderBy
    @WebPopulate(required=true, maxLength=255L)
    protected String name;
    @DAOManaged
    @WebPopulate
    protected boolean anonymousAccess;
    @DAOManaged
    @WebPopulate
    protected boolean userAccess;
    @DAOManaged
    @WebPopulate
    protected boolean adminAccess;
    @DAOManaged
    @WebPopulate
    protected boolean enabled;
    @DAOManaged
    @WebPopulate
    protected Integer dataSourceID;
    @DAOManaged
    @OneToMany(autoAdd=true, autoUpdate=true, autoGet=true)
    @SimplifiedRelation(addTablePrefix=true, deplurifyTablePrefix=true, table="_groups", remoteKeyColumnName="moduleID", remoteValueColumnName="groupID")
    @WebPopulate(paramName="group")
    protected List<Integer> allowedGroupIDs;
    @DAOManaged
    @OneToMany(autoAdd=true, autoUpdate=true, autoGet=true)
    @SimplifiedRelation(addTablePrefix=true, deplurifyTablePrefix=true, table="_users", remoteKeyColumnName="moduleID", remoteValueColumnName="userID")
    @WebPopulate(paramName="user")
    protected List<Integer> allowedUserIDs;
    protected MutableSettingHandler mutableSettingHandler;
    protected SimpleMutableAttributeHandler attributeHandler;

    @Override
    public MutableSettingHandler getMutableSettingHandler() {
        return this.mutableSettingHandler;
    }

    public void setMutableSettingHandler(MutableSettingHandler mutableSettingHandler) {
        this.mutableSettingHandler = mutableSettingHandler;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Integer getModuleID() {
        return this.moduleID;
    }

    public void setModuleID(Integer moduleID) {
        this.moduleID = moduleID;
    }

    @Override
    public Integer getDataSourceID() {
        return this.dataSourceID;
    }

    public void setDataSourceID(Integer dataSourceID) {
        this.dataSourceID = dataSourceID;
    }

    public List<Integer> getAllowedGroupIDs() {
        return this.allowedGroupIDs;
    }

    public void setAllowedGroupIDs(ArrayList<Integer> allowedGroupIDs) {
        this.allowedGroupIDs = allowedGroupIDs;
    }

    public List<Integer> getAllowedUserIDs() {
        return this.allowedUserIDs;
    }

    public void setAllowedUserIDs(ArrayList<Integer> allowedUserIDs) {
        this.allowedUserIDs = allowedUserIDs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean allowsUserAccess() {
        return this.userAccess;
    }

    public void setUserAccess(boolean userAccess) {
        this.userAccess = userAccess;
    }

    public int hashCode() {
        Integer moduleID = this.moduleID;
        if (moduleID == null) {
            return super.hashCode();
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (moduleID == null ? 0 : moduleID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        Integer moduleID = this.moduleID;
        if (moduleID == null) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseModuleDescriptor other = (BaseModuleDescriptor)obj;
        return moduleID.equals(other.moduleID);
    }

    @Override
    public boolean allowsAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(boolean anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    @Override
    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    @Override
    public boolean allowsAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public String toString() {
        return this.name + " (moduleID: " + this.moduleID + ")";
    }

    public Element toXML(Document doc) {
        Element moduleElement = doc.createElement("module");
        if (this.moduleID != null) {
            moduleElement.appendChild(XMLUtils.createElement((String)"moduleID", (Object)this.moduleID.toString(), (Document)doc));
        }
        moduleElement.appendChild(XMLUtils.createCDATAElement((String)"name", (Object)this.name, (Document)doc));
        moduleElement.appendChild(XMLUtils.createElement((String)"classname", (Object)this.classname, (Document)doc));
        if (this.dataSourceID != null) {
            moduleElement.appendChild(XMLUtils.createElement((String)"dataSourceID", (Object)this.dataSourceID.toString(), (Document)doc));
        }
        moduleElement.appendChild(XMLUtils.createElement((String)"adminAccess", (Object)Boolean.toString(this.adminAccess), (Document)doc));
        moduleElement.appendChild(XMLUtils.createElement((String)"userAccess", (Object)Boolean.toString(this.userAccess), (Document)doc));
        moduleElement.appendChild(XMLUtils.createElement((String)"anonymousAccess", (Object)Boolean.toString(this.anonymousAccess), (Document)doc));
        moduleElement.appendChild(XMLUtils.createElement((String)"enabled", (Object)Boolean.toString(this.enabled), (Document)doc));
        AccessUtils.appendAllowedGroupAndUserIDs(doc, moduleElement, this);
        return moduleElement;
    }

    public Element toXML(Document doc, boolean includeSettings, boolean includeAttributes) {
        Element moduleElement = this.toXML(doc);
        if (this.mutableSettingHandler != null) {
            moduleElement.appendChild(this.mutableSettingHandler.toXML(doc));
        }
        if (this.attributeHandler != null) {
            moduleElement.appendChild(this.attributeHandler.toXML(doc));
        }
        return moduleElement;
    }

    public void populate(XMLParser xmlParser) throws ValidationException {
        XMLParser attributeParser;
        ArrayList errors = new ArrayList();
        this.name = (String)XMLValidationUtils.validateParameter((String)"name", (XMLParser)xmlParser, (boolean)true, (Integer)1, (Integer)255, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.classname = (String)XMLValidationUtils.validateParameter((String)"classname", (XMLParser)xmlParser, (boolean)true, (Integer)1, (Integer)255, (BeanStringPopulator)StringPopulator.getPopulator(), errors);
        this.adminAccess = xmlParser.getBoolean("adminAccess");
        this.userAccess = xmlParser.getBoolean("userAccess");
        this.anonymousAccess = xmlParser.getBoolean("anonymousAccess");
        this.enabled = xmlParser.getBoolean("enabled");
        this.dataSourceID = xmlParser.getInteger("dataSourceID");
        this.moduleID = xmlParser.getInteger("moduleID");
        this.allowedGroupIDs = xmlParser.getIntegers("allowedGroupIDs/groupID");
        this.allowedUserIDs = xmlParser.getIntegers("allowedUserIDs/userID");
        XMLParser settingsParser = xmlParser.getNode("settings");
        if (settingsParser != null) {
            this.mutableSettingHandler = new SimpleSettingHandler(settingsParser);
        }
        if ((attributeParser = xmlParser.getNode("Attributes")) != null) {
            this.attributeHandler = new SimpleMutableAttributeHandler(attributeParser, 255, 4096);
        }
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    @Override
    public SimpleMutableAttributeHandler getAttributeHandler() {
        if (this.attributeHandler == null) {
            this.attributeHandler = new SimpleMutableAttributeHandler(255, 4096);
        }
        return this.attributeHandler;
    }

    public void setAttributeHandler(SimpleMutableAttributeHandler attributeHandler) {
        this.attributeHandler = attributeHandler;
    }
}

