/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import se.unlogic.hierarchy.foregroundmodules.userprofile.AttributeMode;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.validation.StringFormatValidator;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;

@XMLElement
public class AttributeDescriptor
extends GeneratedElementable {
    @XMLElement(fixCase=true)
    private final String name;
    @XMLElement(fixCase=true)
    private final String displayName;
    @XMLElement(fixCase=true)
    private final AttributeMode attributeMode;
    @XMLElement(fixCase=true)
    private final Integer maxLength;
    private final StringFormatValidator validator;
    private final StringPopulator stringPopulator;

    public AttributeDescriptor(String name, String displayName, AttributeMode mode, Integer maxLength, StringFormatValidator validator) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (mode == null) {
            throw new NullPointerException("attributeMode cannot be null");
        }
        this.name = name;
        this.displayName = displayName;
        this.attributeMode = mode;
        this.maxLength = maxLength;
        this.validator = validator;
        this.stringPopulator = validator == null ? StringPopulator.getPopulator() : new StringPopulator(validator);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public StringFormatValidator getValidator() {
        return this.validator;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public AttributeMode getAttributeMode() {
        return this.attributeMode;
    }

    public StringPopulator getStringPopulator() {
        return this.stringPopulator;
    }

    public String toString() {
        return this.name + " (display name: " + this.displayName + ", mode: " + (Object)((Object)this.attributeMode) + ")";
    }
}

