/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.beans;

import java.util.regex.Pattern;
import se.unlogic.hierarchy.core.enums.AliasType;

public class AliasMapping {
    private final String alias;
    private final AliasType aliasType;
    private final boolean exclude;
    private final Pattern pattern;

    public AliasMapping(String alias, AliasType aliasType) {
        this(alias, aliasType, false);
    }

    public AliasMapping(String alias, AliasType aliasType, boolean exclude) {
        this.pattern = aliasType.equals((Object)AliasType.REGEXP) ? Pattern.compile(alias) : null;
        this.alias = alias;
        this.aliasType = aliasType;
        this.exclude = exclude;
    }

    public String getAlias() {
        return this.alias;
    }

    public AliasType getAliasType() {
        return this.aliasType;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

