/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.basemodules;

import java.util.concurrent.locks.Lock;
import se.unlogic.hierarchy.core.interfaces.InstanceListener;

public abstract class ReflectionInstanceListener<KeyClass>
implements InstanceListener<KeyClass> {
    protected final Lock writeLock;
    protected final boolean required;
    protected final Object target;
    protected boolean hasInstance;

    public ReflectionInstanceListener(boolean required, Object target, Lock writeLock) {
        this.required = required;
        this.target = target;
        this.writeLock = writeLock;
    }

    @Override
    public <InstanceType extends KeyClass> void instanceAdded(Class<KeyClass> key, InstanceType instance) {
        this.writeLock.lock();
        try {
            this.setInstance(instance);
            this.hasInstance = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <InstanceType extends KeyClass> void instanceRemoved(Class<KeyClass> key, InstanceType instance) {
        this.writeLock.lock();
        try {
            this.hasInstance = false;
            this.setInstance(null);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract <InstanceType extends KeyClass> void setInstance(InstanceType var1);

    public abstract Class getRawKey();

    public boolean isRequired() {
        return this.required;
    }

    public boolean hasInstance() {
        return this.hasInstance;
    }
}

