/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.basemodules;

import java.io.Serializable;
import java.lang.reflect.Method;
import se.unlogic.hierarchy.core.enums.EventSource;
import se.unlogic.hierarchy.core.interfaces.EventListener;

public class ReflectionEventListener<T extends Serializable>
implements EventListener<T> {
    protected final Class<?> channel;
    protected final Class<T> eventType;
    protected final Object target;
    protected final Method method;
    protected final int priority;

    public ReflectionEventListener(Class<?> channel, Class<T> eventType, Object target, Method method, int priority) {
        this.channel = channel;
        this.eventType = eventType;
        this.target = target;
        this.method = method;
        this.priority = priority;
    }

    @Override
    public void processEvent(T event, EventSource eventSource) {
        try {
            this.method.invoke(this.target, new Object[]{event, eventSource});
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public Class<?> getChannel() {
        return this.channel;
    }

    public Class<T> getEventType() {
        return this.eventType;
    }

    public Class getRawEventType() {
        return this.eventType;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

