/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.basemodules;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.basemodules.BaseSectionModule;
import se.unlogic.hierarchy.basemodules.FieldInstanceListener;
import se.unlogic.hierarchy.basemodules.MethodInstanceListener;
import se.unlogic.hierarchy.basemodules.ReflectionEventListener;
import se.unlogic.hierarchy.basemodules.ReflectionInstanceListener;
import se.unlogic.hierarchy.core.annotations.EventListener;
import se.unlogic.hierarchy.core.annotations.InstanceManagerDependency;
import se.unlogic.hierarchy.core.beans.LinkTag;
import se.unlogic.hierarchy.core.beans.ScriptTag;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ModuleResponse;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.interfaces.VisibleModuleDescriptor;
import se.unlogic.hierarchy.core.utils.ModuleUtils;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.xsl.XSLVariableReader;

public abstract class AnnotatedSectionModule<DescriptorType extends VisibleModuleDescriptor>
extends BaseSectionModule<DescriptorType> {
    protected List<ScriptTag> scripts;
    protected List<LinkTag> links;
    protected List<ReflectionInstanceListener<?>> instanceListeners;
    protected boolean hasRequiredDependencies;
    protected List<ReflectionEventListener<?>> eventListeners;
    protected ReentrantReadWriteLock dependencyLock;
    protected Lock dependencyReadLock;

    @Override
    public void init(DescriptorType descriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(descriptor, sectionInterface, dataSource);
        this.parseXSLStyleSheet();
        this.parseSettings(((VisibleModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler());
        this.moduleConfigured();
        ReentrantReadWriteLock dependencyLock = new ReentrantReadWriteLock();
        this.instanceListeners = this.getInstanceListeners(dependencyLock.writeLock());
        if (this.instanceListeners != null) {
            for (ReflectionInstanceListener<?> reflectionInstanceListener : this.instanceListeners) {
                this.log.debug((Object)("Adding instance listener for class " + reflectionInstanceListener.getRawKey()));
                this.systemInterface.getInstanceHandler().addInstanceListener(reflectionInstanceListener.getRawKey(), reflectionInstanceListener);
                if (this.hasRequiredDependencies || !reflectionInstanceListener.isRequired()) continue;
                this.hasRequiredDependencies = true;
            }
            this.dependencyLock = dependencyLock;
            this.dependencyReadLock = dependencyLock.readLock();
        }
        this.eventListeners = this.getEventListeners();
        if (this.eventListeners != null) {
            for (ReflectionEventListener reflectionEventListener : this.eventListeners) {
                this.log.debug((Object)("Adding event listener for channel " + reflectionEventListener.getChannel() + " and event type " + reflectionEventListener.getEventType()));
                this.systemInterface.getEventHandler().addEventListener(reflectionEventListener.getChannel(), reflectionEventListener.getRawEventType(), reflectionEventListener);
            }
        }
    }

    @Override
    public void update(DescriptorType descriptor, DataSource dataSource) throws Exception {
        super.update(descriptor, dataSource);
        this.parseXSLStyleSheet();
        this.parseSettings(descriptor.getMutableSettingHandler());
        this.moduleConfigured();
    }

    protected void moduleConfigured() throws Exception {
    }

    @Override
    public void unload() throws Exception {
        if (this.eventListeners != null) {
            for (ReflectionEventListener reflectionEventListener : this.eventListeners) {
                this.log.debug((Object)("Removing event listener for channel " + reflectionEventListener.getChannel() + " and event type " + reflectionEventListener.getEventType()));
                this.systemInterface.getEventHandler().removeEventListener(reflectionEventListener.getChannel(), reflectionEventListener.getRawEventType(), reflectionEventListener);
            }
        }
        if (this.instanceListeners != null) {
            for (ReflectionInstanceListener reflectionInstanceListener : this.instanceListeners) {
                this.log.debug((Object)("Removing instance listener for class " + reflectionInstanceListener.getRawKey()));
                this.systemInterface.getInstanceHandler().removeInstanceListener(reflectionInstanceListener.getRawKey(), reflectionInstanceListener);
            }
        }
        super.unload();
    }

    protected void parseSettings(MutableSettingHandler mutableSettingHandler) throws Exception {
        ModuleUtils.setModuleSettings(this, BaseSectionModule.class, mutableSettingHandler, this.sectionInterface.getSystemInterface());
    }

    protected void parseXSLStyleSheet() throws SAXException, IOException, ParserConfigurationException, ClassNotFoundException, URISyntaxException {
        XSLVariableReader variableReader = ModuleUtils.getXSLVariableReader((VisibleModuleDescriptor)this.moduleDescriptor, this.sectionInterface.getSystemInterface());
        if (variableReader != null) {
            ModuleUtils.setXSLVariables(variableReader, this, BaseSectionModule.class, (ModuleDescriptor)this.moduleDescriptor);
        }
        if (variableReader != null) {
            List<ScriptTag> globalScripts = ModuleUtils.getGlobalScripts(variableReader);
            List<ScriptTag> localScripts = ModuleUtils.getScripts(variableReader, this.sectionInterface, this.getStaticContentPrefix(), (ModuleDescriptor)this.moduleDescriptor);
            this.scripts = CollectionUtils.combine((Collection[])new Collection[]{globalScripts, localScripts});
            List<LinkTag> globalLinks = ModuleUtils.getGlobalLinks(variableReader);
            List<LinkTag> localLinks = ModuleUtils.getLinks(variableReader, this.sectionInterface, this.getStaticContentPrefix(), (ModuleDescriptor)this.moduleDescriptor);
            this.links = CollectionUtils.combine((Collection[])new Collection[]{globalLinks, localLinks});
        }
    }

    private List<ReflectionInstanceListener<?>> getInstanceListeners(Lock writeLock) {
        ArrayList instanceListeners = new ArrayList();
        List fields = ReflectionUtils.getFields(this.getClass());
        for (Field field : fields) {
            InstanceManagerDependency annotation = field.getAnnotation(InstanceManagerDependency.class);
            if (annotation == null) continue;
            instanceListeners.add(new FieldInstanceListener(this, field, annotation.required(), writeLock));
        }
        List methods = ReflectionUtils.getMethods(this.getClass());
        for (Method method : methods) {
            InstanceManagerDependency annotation = method.getAnnotation(InstanceManagerDependency.class);
            if (annotation == null) continue;
            instanceListeners.add(new MethodInstanceListener(this, method, annotation.required(), writeLock));
        }
        if (instanceListeners.isEmpty()) {
            return null;
        }
        return instanceListeners;
    }

    private List<ReflectionEventListener<?>> getEventListeners() {
        ArrayList eventListeners = new ArrayList();
        List methods = ReflectionUtils.getMethods(this.getClass());
        for (Method method : methods) {
            EventListener annotation = method.getAnnotation(EventListener.class);
            if (annotation == null) continue;
            eventListeners.add(new ReflectionEventListener(annotation.channel(), method.getParameterTypes()[0], this, method, annotation.priority()));
        }
        if (eventListeners.isEmpty()) {
            return null;
        }
        return eventListeners;
    }

    protected abstract String getStaticContentPrefix();

    @Override
    public List<SettingDescriptor> getSettings() {
        ArrayList<SettingDescriptor> settingDescriptors = new ArrayList<SettingDescriptor>();
        ModuleUtils.addSettings(settingDescriptors, super.getSettings());
        try {
            ModuleUtils.addSettings(settingDescriptors, ModuleUtils.getAnnotatedSettingDescriptors(this, BaseSectionModule.class, this.systemInterface));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return settingDescriptors;
    }

    protected void setLinksAndScripts(ModuleResponse moduleResponse) {
        if (this.scripts != null) {
            moduleResponse.addScripts(this.scripts);
        }
        if (this.links != null) {
            moduleResponse.addLinks(this.links);
        }
    }
}

