/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.backgroundmodules.socialmedia;

import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.backgroundmodules.AnnotatedBackgroundModule;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.beans.SimpleBackgroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleResponse;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;

public class SocialMediaModule
extends AnnotatedBackgroundModule {
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Use Facebook", description="Show Facebook like button")
    protected boolean showFacebook = true;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Use Twitter", description="Show Twitter tweet button")
    protected boolean showTwitter = true;

    @Override
    public BackgroundModuleResponse processBackgroundRequest(HttpServletRequest req, User user, URIParser uriParser) throws Exception {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        XMLUtils.appendNewElement((Document)doc, (Element)document, (String)"staticcontentPath", (String)(req.getContextPath() + "/static/b/" + ((BackgroundModuleDescriptor)this.moduleDescriptor).getSectionID() + "/" + ((BackgroundModuleDescriptor)this.moduleDescriptor).getModuleID()));
        XMLUtils.appendNewElement((Document)doc, (Element)document, (String)"protocol", (String)req.getScheme());
        Object requestedURL = req.getAttribute("URLFilter.originalURL");
        if (requestedURL != null && requestedURL instanceof String) {
            document.appendChild(XMLUtils.createElement((String)"url", (Object)requestedURL, (Document)doc));
        } else {
            document.appendChild(XMLUtils.createElement((String)"url", (Object)req.getRequestURL().toString(), (Document)doc));
        }
        if (this.showFacebook) {
            document.appendChild(XMLUtils.createElement((String)"showFacebook", (Object)"true", (Document)doc));
        }
        if (this.showTwitter) {
            document.appendChild(XMLUtils.createElement((String)"showTwitter", (Object)"true", (Document)doc));
        }
        doc.appendChild(document);
        return new SimpleBackgroundModuleResponse(doc);
    }
}

