/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.backgroundmodules.sessionkeepalive;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import se.unlogic.hierarchy.backgroundmodules.AnnotatedBackgroundModule;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.beans.ScriptTag;
import se.unlogic.hierarchy.core.beans.SimpleBackgroundModuleResponse;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.sessionkeepalive.SessionKeepAliveConnectorModule;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.PositiveStringIntegerValidator;
import se.unlogic.webutils.http.URIParser;

public class SessionKeepAliveModule
extends AnnotatedBackgroundModule {
    protected static final ScriptTag JQUERY_SCRIPT_TAG = new ScriptTag("/static/global/jquery/jquery.js");
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Connector module name", description="Name to be used for the automatically added session keep alive connector module", required=true)
    protected String connectorModuleName = "Session Keep alive connector";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Invitation module alias", description="Alias to be used for the automatically added session keep alive connector module", required=true)
    protected String connectorModuleAlias = "keepaliveconnector";
    @ModuleSetting
    @TextFieldSettingDescriptor(name="Poll frequency", description="Controls at which interval the clients contact the connector (speicified in seconds)", required=true, formatValidator=PositiveStringIntegerValidator.class)
    protected int keepAlivePollFrequency = 60;
    protected SimpleForegroundModuleDescriptor connectorModuleDescriptor;

    @Override
    public void init(BackgroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        this.checkConnectorModule();
    }

    @Override
    public void update(BackgroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
        this.checkConnectorModule();
    }

    @Override
    public void unload() throws Exception {
        this.unloadConnectorModule();
        super.unload();
    }

    @Override
    public BackgroundModuleResponse processBackgroundRequest(HttpServletRequest req, User user, URIParser uriParser) throws Exception {
        if (this.connectorModuleDescriptor != null && this.scripts != null) {
            SimpleBackgroundModuleResponse moduleResponse = new SimpleBackgroundModuleResponse("");
            return moduleResponse;
        }
        return null;
    }

    protected synchronized void checkConnectorModule() {
        if (StringUtils.isEmpty((String)this.connectorModuleAlias) || StringUtils.isEmpty((String)this.connectorModuleName)) {
            if (this.connectorModuleDescriptor == null) {
                this.log.warn((Object)"Module not properly configured, refusing to create instance of connector module");
            } else {
                this.log.warn((Object)"Module not properly configured, stopping current instance of connector module");
                this.unloadConnectorModule();
            }
        } else if (this.connectorModuleDescriptor == null) {
            SimpleForegroundModuleDescriptor connectorModuleDescriptor = new SimpleForegroundModuleDescriptor();
            connectorModuleDescriptor.setSectionID(this.systemInterface.getRootSection().getSectionDescriptor().getSectionID());
            connectorModuleDescriptor.setClassname(SessionKeepAliveConnectorModule.class.getName());
            connectorModuleDescriptor.setAdminAccess(true);
            connectorModuleDescriptor.setUserAccess(true);
            connectorModuleDescriptor.setAnonymousAccess(true);
            connectorModuleDescriptor.setVisibleInMenu(false);
            connectorModuleDescriptor.setDataSourceID(((BackgroundModuleDescriptor)this.moduleDescriptor).getDataSourceID());
            connectorModuleDescriptor.setAlias(this.connectorModuleAlias);
            connectorModuleDescriptor.setName(this.connectorModuleName);
            connectorModuleDescriptor.setDescription(this.connectorModuleName);
            connectorModuleDescriptor.setMutableSettingHandler(((BackgroundModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler());
            try {
                this.systemInterface.getRootSection().getForegroundModuleCache().cache(connectorModuleDescriptor);
                this.generateScripts();
                this.connectorModuleDescriptor = connectorModuleDescriptor;
            }
            catch (Exception e) {
                this.log.error((Object)"Error caching connector module", (Throwable)e);
            }
        } else {
            this.log.info((Object)"Updating connector module");
            this.connectorModuleDescriptor.setDataSourceID(((BackgroundModuleDescriptor)this.moduleDescriptor).getDataSourceID());
            this.connectorModuleDescriptor.setAlias(this.connectorModuleAlias);
            this.connectorModuleDescriptor.setName(this.connectorModuleName);
            this.connectorModuleDescriptor.setDescription(this.connectorModuleName);
            this.connectorModuleDescriptor.setMutableSettingHandler(((BackgroundModuleDescriptor)this.moduleDescriptor).getMutableSettingHandler());
            try {
                this.systemInterface.getRootSection().getForegroundModuleCache().update(this.connectorModuleDescriptor);
                this.generateScripts();
            }
            catch (Exception e) {
                this.log.error((Object)"Error updating connector module", (Throwable)e);
            }
        }
    }

    private void generateScripts() {
        ArrayList<ScriptTag> scripts = new ArrayList<ScriptTag>(2);
        scripts.add(JQUERY_SCRIPT_TAG);
        scripts.add(new ScriptTag("/" + this.connectorModuleAlias + "/keepalive.js"));
        this.scripts = scripts;
    }

    protected synchronized void unloadConnectorModule() {
        try {
            if (this.systemInterface.getRootSection().getForegroundModuleCache().isCached(this.connectorModuleDescriptor)) {
                this.systemInterface.getRootSection().getForegroundModuleCache().unload(this.connectorModuleDescriptor);
            }
            this.connectorModuleDescriptor = null;
        }
        catch (Exception e) {
            this.log.error((Object)"Error unloading connector module", (Throwable)e);
        }
    }
}

