/*******************************************************************************
 * Copyright (c) 2010 Robert "Unlogic" Olofsson (unlogic@unlogic.se).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0-standalone.html
 ******************************************************************************/
package se.unlogic.hierarchy.foregroundmodules.invitation.beans;

import se.unlogic.emailutils.populators.EmailPopulator;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;

@XMLElement
public class BaseInvitationType extends GeneratedElementable {

	@DAOManaged(autoGenerated=true)
	@Key
	@XMLElement
	private Integer invitationTypeID;

	@DAOManaged
	@WebPopulate(required=true,maxLength=255)
	@XMLElement
	private String name;

	@DAOManaged
	@WebPopulate(required=true,maxLength=255)
	@XMLElement
	private String subject;

	@DAOManaged
	@WebPopulate(required=true,maxLength=65535)
	@XMLElement
	private String message;

	@DAOManaged
	@WebPopulate(required=true,maxLength=255)
	@XMLElement
	private String senderName;

	@DAOManaged
	@WebPopulate(required=true, populator=EmailPopulator.class,maxLength=255)
	@XMLElement
	private String senderEmail;

	@DAOManaged
	@WebPopulate(required=true,maxLength=65535)
	@XMLElement
	private String registrationText;

	@DAOManaged
	@WebPopulate(required=true,maxLength=65535)
	@XMLElement
	private String registeredText;

	public Integer getInvitationTypeID() {
		return invitationTypeID;
	}

	public void setInvitationTypeID(Integer invitationID) {
		this.invitationTypeID = invitationID;
	}

	public String getSenderName() {
		return senderName;
	}

	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	public String getSenderEmail() {
		return senderEmail;
	}

	public void setSenderEmail(String senderEmail) {
		this.senderEmail = senderEmail;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Override
	public String toString() {
		return this.name + " (ID: " + this.invitationTypeID + ")";
	}


	public String getRegistrationText() {

		return registrationText;
	}


	public void setRegistrationText(String registrationText) {

		this.registrationText = registrationText;
	}


	public String getRegisteredText() {

		return registeredText;
	}


	public void setRegisteredText(String registeredText) {

		this.registeredText = registeredText;
	}
}
