/*******************************************************************************
 * Copyright (c) 2010 Robert "Unlogic" Olofsson (unlogic@unlogic.se).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0-standalone.html
 ******************************************************************************/
package se.unlogic.hierarchy.foregroundmodules.invitation.beans;

import java.sql.Timestamp;
import java.util.UUID;

import se.unlogic.emailutils.populators.EmailPopulator;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.xml.GeneratedElementable;
import se.unlogic.standardutils.xml.XMLElement;

@XMLElement
public abstract class BaseInvitation extends GeneratedElementable {

	@DAOManaged(autoGenerated = true)
	@Key
	@XMLElement
	private Integer invitationID;

	@DAOManaged
	@WebPopulate(required = true, populator = EmailPopulator.class)
	@XMLElement
	private String email;

	@DAOManaged
	@WebPopulate(required = true, maxLength = 30)
	@XMLElement
	private String firstname;

	@DAOManaged
	@WebPopulate(required = true, maxLength = 40)
	@XMLElement
	private String lastname;

	@DAOManaged
	@XMLElement
	private UUID linkID;

	@DAOManaged
	@XMLElement
	private int sendCount;

	@DAOManaged
	@XMLElement
	private Timestamp lastSent;

	public Integer getInvitationID() {

		return invitationID;
	}

	public void setInvitationID(Integer invitationID) {

		this.invitationID = invitationID;
	}

	public String getEmail() {

		return email;
	}

	public void setEmail(String email) {

		this.email = email;
	}

	public String getFirstname() {

		return firstname;
	}

	public void setFirstname(String firstname) {

		this.firstname = firstname;
	}

	public String getLastname() {

		return lastname;
	}

	public void setLastname(String lastname) {

		this.lastname = lastname;
	}

	public UUID getLinkID() {

		return linkID;
	}

	public void setLinkID(UUID linkID) {

		this.linkID = linkID;
	}

	public int getSendCount() {

		return sendCount;
	}

	public void setSendCount(int sendCount) {

		this.sendCount = sendCount;
	}

	public Timestamp getLastSent() {

		return lastSent;
	}

	public void setLastSent(Timestamp lastSent) {

		this.lastSent = lastSent;
	}

	@Override
	public String toString() {

		return this.firstname + " " + this.lastname + " (ID: " + this.invitationID + ")";
	}

	public abstract <IT extends BaseInvitationType> IT getInvitationType();

	@Override
	public int hashCode() {

		final int prime = 31;
		int result = 1;
		result = prime * result + ((invitationID == null) ? 0 : invitationID.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {

		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		BaseInvitation other = (BaseInvitation) obj;
		if (invitationID == null) {
			if (other.invitationID != null) {
				return false;
			}
		} else if (!invitationID.equals(other.invitationID)) {
			return false;
		}
		return true;
	}
}
