/*******************************************************************************
 * Copyright (c) 2010 Robert "Unlogic" Olofsson (unlogic@unlogic.se).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0-standalone.html
 ******************************************************************************/
package se.unlogic.hierarchy.foregroundmodules.hddtemp;



import java.sql.Timestamp;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.hddtemp.Drive;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLGenerator;

@Table(name = "hddtemp_drives")
@XMLElement
public class ServerDrive implements Elementable {

	@XMLElement
	@DAOManaged(autoGenerated = true)
	@Key
	private Integer driveID;

	@XMLElement
	@DAOManaged
	@OrderBy
	private String device;

	@XMLElement
	@DAOManaged(columnName="serverID")
	@ManyToOne(remoteKeyField="serverID")
	private Server server;

	@XMLElement
	@DAOManaged
	@WebPopulate
	private Integer maxTemp;

	@XMLElement
	@DAOManaged
	@WebPopulate
	private Integer minTemp;

	@XMLElement
	@DAOManaged
	private Timestamp lastAlarm;

	@XMLElement
	private Drive driveTemp;

	public ServerDrive() {}

	public ServerDrive(Drive drive) {

		this.device = drive.getDevice();
	}

	@Override
	public Element toXML(Document doc) {

		return XMLGenerator.toXML(this, doc);
	}

	public String getDevice() {

		return device;
	}

	public void setDevice(String drive) {

		this.device = drive;
	}

	public Integer getMaxTemp() {

		return maxTemp;
	}

	public void setMaxTemp(Integer maxTemp) {

		this.maxTemp = maxTemp;
	}

	public Integer getMinTemp() {

		return minTemp;
	}

	public void setMinTemp(Integer minTemp) {

		this.minTemp = minTemp;
	}


	public Server getServer() {

		return server;
	}


	public void setServer(Server server) {

		this.server = server;
	}


	public Timestamp getLastAlarm() {

		return lastAlarm;
	}


	public void setLastAlarm(Timestamp lastAlarm) {

		this.lastAlarm = lastAlarm;
	}


	public Drive getDriveTemp() {

		return driveTemp;
	}


	public void setDriveTemp(Drive driveTemp) {

		this.driveTemp = driveTemp;
	}


	public Integer getDriveID() {

		return driveID;
	}


	public void setDriveID(Integer driveID) {

		this.driveID = driveID;
	}

	@Override
	public String toString() {

		return this.device + " (ID: " + this.driveID + ")";
	}
}
