/*******************************************************************************
 * Copyright (c) 2010 Robert "Unlogic" Olofsson (unlogic@unlogic.se).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0-standalone.html
 ******************************************************************************/
package se.unlogic.hierarchy.core.beans;

import java.sql.Timestamp;

import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.i18n.Language;

@Table(name="users")
public abstract class BaseUser extends MutableUser {

	private static final long serialVersionUID = 7247745694183783060L;

	@Key
	@DAOManaged(autoGenerated=true)
	private Integer userID;

	@DAOManaged
	private Timestamp added;

	@DAOManaged
	private String email;

	@DAOManaged
	@OrderBy
	private String firstname;

	@DAOManaged
	@OrderBy
	private String lastname;

	@DAOManaged
	private String password;

	@DAOManaged
	private String username;

	@DAOManaged
	private Language language;

	@DAOManaged
	private boolean admin;

	@DAOManaged
	@WebPopulate
	private boolean enabled;

	@DAOManaged
	private Timestamp lastLogin;

	@DAOManaged
	private String preferedDesign;

	private Timestamp currentLogin;

	protected Integer providerID;

	private boolean formProvider;

	@Override
	public Timestamp getLastLogin() {
		return lastLogin;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setLastLogin(java.sql.Timestamp)
	 */
	@Override
	public void setLastLogin(Timestamp lastLogin) {
		this.lastLogin = lastLogin;
	}

	@Override
	public Timestamp getAdded() {
		return added;
	}

	public void setAdded(Timestamp added) {
		this.added = added;
	}

	@Override
	public String getEmail() {
		return email;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setEmail(java.lang.String)
	 */
	@Override
	@WebPopulate(required=true,maxLength=255,populatorID="email")
	public void setEmail(String email) {
		this.email = email;
	}

	@Override
	public String getFirstname() {
		return firstname;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setFirstname(java.lang.String)
	 */
	@Override
	@WebPopulate(required=true,maxLength=30)
	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	@Override
	public String getLastname() {
		return lastname;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setLastname(java.lang.String)
	 */
	@Override
	@WebPopulate(required=true,maxLength=40)
	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	@Override
	public String getPassword() {
		return password;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setPassword(java.lang.String)
	 */
	@Override
	@WebPopulate(maxLength=255)
	//TODO @PopulateOnlyIfSet(paramNames="setpassword")
	public void setPassword(String password) {
		this.password = password;
	}

	@Override
	public Integer getUserID() {
		return userID;
	}

	@Override
	public void setUserID(Integer userID) {
		this.userID = userID;
	}

	@Override
	public String getUsername() {
		return username;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setUsername(java.lang.String)
	 */
	@Override
	@WebPopulate(required=true,maxLength=40)
	public void setUsername(String username) {
		this.username = username;
	}

	@Override
	public Language getLanguage() {
		return language;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setLanguage(se.unlogic.standardutils.i18n.Language)
	 */
	@Override
	public void setLanguage(Language language) {
		this.language = language;
	}

	@Override
	public boolean isAdmin() {
		return admin;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setAdmin(boolean)
	 */
	@Override
	@WebPopulate
	public void setAdmin(boolean admin) {
		this.admin = admin;
	}

	@Override
	public boolean isEnabled() {
		return enabled;
	}

	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setEnabled(boolean)
	 */
	@Override
	@WebPopulate
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}


	@Override
	public Timestamp getCurrentLogin() {
		return currentLogin;
	}


	/* (non-Javadoc)
	 * @see se.unlogic.hierarchy.core.beans.MutableUser#setCurrentLogin(java.sql.Timestamp)
	 */
	@Override
	public void setCurrentLogin(Timestamp currentLogin) {
		this.currentLogin = currentLogin;
	}


	public Integer getProviderID() {

		return providerID;
	}


	public void setProviderID(Integer providerID) {

		this.providerID = providerID;
	}

	public void setPreferedDesign(String preferedDesign) {

		this.preferedDesign = preferedDesign;
	}

	@Override
	public String getPreferedDesign() {

		return preferedDesign;
	}

	@Override
	public boolean hasFormProvider() {

		return formProvider;
	}

	public void setFormProvider(boolean formProvider) {

		this.formProvider = formProvider;
	}
}
