/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.fileuploadutils;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class SafeDiskFileItemFactory
extends DiskFileItemFactory {
    protected ArrayList<FileItem> itemList = new ArrayList();

    public SafeDiskFileItemFactory() {
    }

    public SafeDiskFileItemFactory(int sizeThreshold, File repository) {
        super(sizeThreshold, repository);
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        FileItem item = super.createItem(fieldName, contentType, isFormField, fileName);
        if (item != null && !item.isFormField()) {
            this.itemList.add(item);
        }
        return item;
    }

    public void deleteFiles() {
        if (!this.itemList.isEmpty()) {
            Iterator<FileItem> iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                FileItem item = iterator.next();
                item.delete();
                iterator.remove();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.deleteFiles();
        super.finalize();
    }
}

