/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.fileuploadutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import se.unlogic.fileuploadutils.IteratorEnumeration;
import se.unlogic.fileuploadutils.SafeDiskFileItemFactory;

public class MultipartRequest
implements HttpServletRequest {
    private final SafeDiskFileItemFactory factory;
    private final ServletFileUpload uploadHandler;
    private final HashMap<String, String[]> parameterMap = new HashMap();
    private final HashMap<String, List<FileItem>> fileMap = new HashMap();
    private final ArrayList<FileItem> fileItemList = new ArrayList();
    private final HttpServletRequest originalRequest;

    public MultipartRequest(int ramThreshold, long maxSize, HttpServletRequest req) throws FileUploadException {
        this(ramThreshold, maxSize, (File)null, req);
    }

    public MultipartRequest(int ramThreshold, long maxSize, long maxFileSize, HttpServletRequest req) throws FileUploadException {
        this(ramThreshold, maxSize, maxFileSize, null, req);
    }

    public MultipartRequest(int ramThreshold, long maxSize, String repository, HttpServletRequest req) throws FileUploadException {
        this(ramThreshold, maxSize, repository != null ? new File(repository) : null, req);
    }

    public MultipartRequest(int ramThreshold, long maxSize, File repository, HttpServletRequest req) throws FileUploadException {
        this(ramThreshold, maxSize, null, repository, req);
    }

    public MultipartRequest(int ramThreshold, long maxSize, Long maxFileSize, File repository, HttpServletRequest req) throws FileUploadException {
        this.originalRequest = req;
        this.factory = new SafeDiskFileItemFactory(ramThreshold, repository);
        this.uploadHandler = new ServletFileUpload((FileItemFactory)this.factory);
        this.uploadHandler.setSizeMax(maxSize);
        if (maxFileSize != null) {
            this.uploadHandler.setFileSizeMax(maxFileSize.longValue());
        }
        HashMap<String, ArrayList<String>> tempParameterMap = new HashMap<String, ArrayList<String>>();
        try {
            List items = this.uploadHandler.parseRequest(req);
            if (items != null && items.size() > 0) {
                for (FileItem fileItem : items) {
                    if (fileItem.isFormField()) {
                        Field contentType = fileItem.getClass().getDeclaredField("contentType");
                        contentType.setAccessible(true);
                        contentType.set(fileItem, "charset=UTF-8;");
                        ArrayList<String> valueList = (ArrayList<String>)tempParameterMap.get(fileItem.getFieldName());
                        if (valueList != null) {
                            valueList.add(fileItem.getString());
                            continue;
                        }
                        valueList = new ArrayList<String>();
                        valueList.add(fileItem.getString());
                        tempParameterMap.put(fileItem.getFieldName(), valueList);
                        continue;
                    }
                    List<FileItem> fileItems = this.fileMap.get(fileItem.getFieldName());
                    if (fileItems == null) {
                        fileItems = new ArrayList<FileItem>(10);
                        this.fileMap.put(fileItem.getFieldName(), fileItems);
                    }
                    fileItems.add(fileItem);
                    this.fileItemList.add(fileItem);
                }
            }
            if (!tempParameterMap.isEmpty()) {
                for (Map.Entry entry : tempParameterMap.entrySet()) {
                    this.parameterMap.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
                }
            }
        }
        catch (FileUploadException e) {
            this.factory.deleteFiles();
            throw e;
        }
        catch (IllegalAccessException e) {
            this.factory.deleteFiles();
        }
        catch (NoSuchFieldException e) {
            this.factory.deleteFiles();
        }
    }

    public int getParameterCount() {
        return this.parameterMap.size();
    }

    public Enumeration<?> getParameterNames() {
        return new IteratorEnumeration<String>(this.parameterMap.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public int getFileCount() {
        return this.fileItemList.size();
    }

    public String getParameter(String name) {
        String[] values = this.parameterMap.get(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public FileItem getFile(String name) {
        List<FileItem> files = this.fileMap.get(name);
        if (files == null || files.isEmpty()) {
            return null;
        }
        return files.get(0);
    }

    public List<FileItem> getFiles(String name) {
        return this.fileMap.get(name);
    }

    public void deleteFiles() {
        this.factory.deleteFiles();
    }

    public FileItem getFile(int index) {
        return this.fileItemList.get(index);
    }

    public ArrayList<FileItem> getFiles() {
        return (ArrayList)this.fileItemList.clone();
    }

    public static boolean isMultipartRequest(HttpServletRequest req) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)req);
    }

    public String getAuthType() {
        return this.originalRequest.getAuthType();
    }

    public String getContextPath() {
        return this.originalRequest.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.originalRequest.getCookies();
    }

    public long getDateHeader(String arg0) {
        return this.originalRequest.getDateHeader(arg0);
    }

    public String getHeader(String arg0) {
        return this.originalRequest.getHeader(arg0);
    }

    public Enumeration<?> getHeaderNames() {
        return this.originalRequest.getHeaderNames();
    }

    public Enumeration<?> getHeaders(String arg0) {
        return this.originalRequest.getHeaders(arg0);
    }

    public int getIntHeader(String arg0) {
        return this.originalRequest.getIntHeader(arg0);
    }

    public String getMethod() {
        return this.originalRequest.getMethod();
    }

    public String getPathInfo() {
        return this.originalRequest.getPathInfo();
    }

    public String getPathTranslated() {
        return this.originalRequest.getPathTranslated();
    }

    public String getQueryString() {
        return this.originalRequest.getQueryString();
    }

    public String getRemoteUser() {
        return this.originalRequest.getRemoteUser();
    }

    public String getRequestURI() {
        return this.originalRequest.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.originalRequest.getRequestURL();
    }

    public String getRequestedSessionId() {
        return this.originalRequest.getRequestedSessionId();
    }

    public String getServletPath() {
        return this.originalRequest.getServletPath();
    }

    public HttpSession getSession() {
        return this.originalRequest.getSession();
    }

    public HttpSession getSession(boolean arg0) {
        return this.originalRequest.getSession(arg0);
    }

    public Principal getUserPrincipal() {
        return this.originalRequest.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.originalRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.originalRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.originalRequest.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        return this.originalRequest.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String arg0) {
        return this.originalRequest.isUserInRole(arg0);
    }

    public Object getAttribute(String arg0) {
        return this.originalRequest.getAttribute(arg0);
    }

    public Enumeration<?> getAttributeNames() {
        return this.originalRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.originalRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.originalRequest.getContentLength();
    }

    public String getContentType() {
        return this.originalRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.originalRequest.getInputStream();
    }

    public String getLocalAddr() {
        return this.originalRequest.getLocalAddr();
    }

    public String getLocalName() {
        return this.originalRequest.getLocalName();
    }

    public int getLocalPort() {
        return this.originalRequest.getLocalPort();
    }

    public Locale getLocale() {
        return this.originalRequest.getLocale();
    }

    public Enumeration<?> getLocales() {
        return this.originalRequest.getLocales();
    }

    public Map<?, ?> getParameterMap() {
        return this.parameterMap;
    }

    public String getProtocol() {
        return this.originalRequest.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return this.originalRequest.getReader();
    }

    public String getRealPath(String arg0) {
        return this.originalRequest.getRealPath(arg0);
    }

    public String getRemoteAddr() {
        return this.originalRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.originalRequest.getRemoteHost();
    }

    public int getRemotePort() {
        return this.originalRequest.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.originalRequest.getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return this.originalRequest.getScheme();
    }

    public String getServerName() {
        return this.originalRequest.getServerName();
    }

    public int getServerPort() {
        return this.originalRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.originalRequest.isSecure();
    }

    public void removeAttribute(String arg0) {
        this.originalRequest.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.originalRequest.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.originalRequest.setCharacterEncoding(arg0);
    }
}

