/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.emailutils.framework;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import se.unlogic.emailutils.framework.Attachment;
import se.unlogic.emailutils.framework.BaseAttachment;

public class StringAttachment
extends BaseAttachment
implements Attachment {
    private final String filename;
    private final String message;
    private final String contentType;

    public StringAttachment(String message, String contentType) {
        this.filename = null;
        this.message = message;
        this.contentType = contentType;
    }

    public StringAttachment(String filename, String message, String contentType) {
        this.filename = filename;
        this.message = message;
        this.contentType = contentType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public MimeBodyPart getMimeBodyPart() {
        MimeBodyPart textPart = new MimeBodyPart();
        try {
            textPart.setContent((Object)this.message, this.contentType);
            if (this.filename != null) {
                textPart.setFileName(this.filename);
            }
            this.setDisposition(textPart);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return textPart;
    }
}

