/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.emailutils.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailHandler;
import se.unlogic.emailutils.framework.EmailSender;
import se.unlogic.emailutils.framework.EmailSenderComparator;
import se.unlogic.emailutils.framework.NoEmailSendersFoundException;
import se.unlogic.emailutils.framework.UnableToProcessEmailException;

public class StopableEmailHandler
implements EmailHandler {
    private static final EmailSenderComparator COMPARATOR = new EmailSenderComparator();
    private final ArrayList<EmailSender> emailSenders = new ArrayList();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private boolean stopped = false;

    @Override
    public boolean addSender(EmailSender emailSender) {
        if (this.stopped) {
            throw new IllegalStateException("EmailHandler has been shutdown, no new email senders can be added!");
        }
        if (emailSender == null) {
            throw new NullPointerException("EmailSender cannot be null!");
        }
        try {
            this.writeLock.lock();
            if (!this.emailSenders.contains(emailSender)) {
                this.emailSenders.add(emailSender);
                Collections.sort(this.emailSenders, COMPARATOR);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeSender(EmailSender emailSender) {
        if (this.stopped) {
            throw new IllegalStateException("EmailHandler has been shutdown!");
        }
        if (emailSender == null) {
            throw new NullPointerException("emailSender cannot be null!");
        }
        try {
            this.writeLock.lock();
            if (this.emailSenders.contains(emailSender)) {
                this.emailSenders.remove(emailSender);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeSenders() {
        try {
            this.writeLock.lock();
            for (EmailSender emailSender : this.emailSenders) {
                this.emailSenders.remove(emailSender);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public synchronized void stop() {
        try {
            this.writeLock.lock();
            if (!this.stopped) {
                this.stopped = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public synchronized void start() {
        try {
            this.writeLock.lock();
            if (this.stopped) {
                this.stopped = false;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getSenderCount() {
        try {
            this.readLock.lock();
            int n = this.emailSenders.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void send(Email email) throws NoEmailSendersFoundException, UnableToProcessEmailException {
        if (this.stopped) {
            throw new IllegalStateException("EmailHandler has been shutdown!");
        }
        try {
            this.readLock.lock();
            if (this.emailSenders.isEmpty()) {
                throw new NoEmailSendersFoundException();
            }
            for (EmailSender emailSender : this.emailSenders) {
                if (!emailSender.send(email)) continue;
                return;
            }
            throw new UnableToProcessEmailException();
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean hasSenders() {
        try {
            this.readLock.lock();
            boolean bl = !this.emailSenders.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

