/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.emailutils.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import se.unlogic.emailutils.framework.Attachment;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailUtils;
import se.unlogic.emailutils.framework.InvalidEmailAddressException;

public class SimpleEmail
implements Email {
    public static final String TEXT = "text/plain";
    public static final String HTML = "text/html";
    public static final String DEFAULT_CHARSET = "Cp1252";
    private final ArrayList<Attachment> attachments = new ArrayList();
    private final ArrayList<String> bccRecipients = new ArrayList();
    private final ArrayList<String> ccRecipients = new ArrayList();
    private final ArrayList<String> recipients = new ArrayList();
    private final ArrayList<String> replyTo = new ArrayList();
    private String senderName;
    private String senderAddress;
    private String charset = "Cp1252";
    private String messageContentType = "text/plain";
    private String subject;
    private String message;
    private Date sentDate;

    public String toString() {
        if (this.recipients.size() == 1 && this.bccRecipients.size() == 0 && this.ccRecipients.size() == 0) {
            return this.subject + " (to: " + this.recipients.get(0) + ")";
        }
        return this.subject + " (to: " + (this.bccRecipients.size() + this.ccRecipients.size() + this.recipients.size()) + " recipient(s))";
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public ArrayList<String> getReplyTo() {
        return this.replyTo;
    }

    @Override
    public String getMessageContentType() {
        return this.messageContentType;
    }

    @Override
    public List<String> getRecipients() {
        return this.recipients;
    }

    public void addRecipient(String address) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress(address)) {
            throw new InvalidEmailAddressException(address);
        }
        this.recipients.add(address);
    }

    public boolean addRecipients(Collection<String> addresses) throws InvalidEmailAddressException {
        this.validateAddresses(addresses);
        return this.recipients.addAll(addresses);
    }

    @Override
    public String getSenderName() {
        return this.senderName;
    }

    @Override
    public String getSenderAddress() {
        return this.senderAddress;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public boolean add(Attachment o) {
        return this.attachments.add(o);
    }

    public boolean addAll(Collection<? extends Attachment> c) {
        return this.attachments.addAll(c);
    }

    @Override
    public List<String> getBccRecipients() {
        return this.bccRecipients;
    }

    public void addBccRecipient(String address) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress(address)) {
            throw new InvalidEmailAddressException(address);
        }
        this.bccRecipients.add(address);
    }

    public boolean addBccRecipients(Collection<String> addresses) throws InvalidEmailAddressException {
        this.validateAddresses(addresses);
        return this.bccRecipients.addAll(addresses);
    }

    @Override
    public List<String> getCcRecipients() {
        return this.ccRecipients;
    }

    public void addCcRecipient(String address) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress(address)) {
            throw new InvalidEmailAddressException(address);
        }
        this.ccRecipients.add(address);
    }

    public boolean addCcRecipients(Collection<String> addresses) throws InvalidEmailAddressException {
        this.validateAddresses(addresses);
        return this.ccRecipients.addAll(addresses);
    }

    public void setSenderAddress(String senderAddress) throws InvalidEmailAddressException {
        if (!EmailUtils.isValidEmailAddress(senderAddress)) {
            throw new InvalidEmailAddressException(senderAddress);
        }
        this.senderAddress = senderAddress;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setMessageContentType(String messageContentType) {
        this.messageContentType = messageContentType;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private void validateAddresses(Collection<String> addresses) throws InvalidEmailAddressException {
        if (addresses == null) {
            throw new InvalidEmailAddressException(null);
        }
        for (String address : addresses) {
            if (EmailUtils.isValidEmailAddress(address)) continue;
            throw new InvalidEmailAddressException(address);
        }
    }

    @Override
    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }
}

