/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.emailutils.framework;

import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import se.unlogic.emailutils.framework.Attachment;
import se.unlogic.emailutils.framework.BaseAttachment;
import se.unlogic.standardutils.mime.MimeUtils;

public class FileAttachment
extends BaseAttachment
implements Attachment {
    private final File file;
    private final String filename;
    private String contentType;

    public FileAttachment(File file) {
        this.file = file;
        this.filename = file.getName();
    }

    public FileAttachment(File file, String filename) {
        this.file = file;
        this.filename = filename;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public MimeBodyPart getMimeBodyPart() {
        MimeBodyPart filePart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(this.file);
        try {
            filePart.setDataHandler(new DataHandler((DataSource)fds));
            if (this.contentType == null) {
                this.contentType = MimeUtils.getMimeType((String)this.filename);
            }
            filePart.setHeader("Content-Type", this.contentType);
            if (!this.contentType.startsWith("text/")) {
                filePart.setHeader("Content-Transfer-Encoding", "base64");
            }
            filePart.setFileName(this.filename);
            this.setDisposition(filePart);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return filePart;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

