/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.emailutils.framework;

import java.util.Date;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import se.unlogic.emailutils.framework.Attachment;
import se.unlogic.emailutils.framework.Email;
import se.unlogic.emailutils.framework.EmailUtils;

public class EmailConverter {
    public static MimeMessage convert(Email email, Session session) throws MessagingException {
        MimeMessage message = new MimeMessage(session);
        message.setSubject(email.getSubject());
        message.setFrom(EmailUtils.getAddresses(email.getSenderAddress(), email.getSenderName()));
        message.setReplyTo(EmailUtils.getAddresses(email.getReplyTo()));
        message.setRecipients(MimeMessage.RecipientType.TO, EmailUtils.getAddresses(email.getRecipients()));
        message.setRecipients(MimeMessage.RecipientType.CC, EmailUtils.getAddresses(email.getCcRecipients()));
        message.setRecipients(MimeMessage.RecipientType.BCC, EmailUtils.getAddresses(email.getBccRecipients()));
        if (email.getSentDate() != null) {
            message.setSentDate(email.getSentDate());
        } else {
            message.setSentDate(new Date());
        }
        if (email.getAttachments() != null && !email.getAttachments().isEmpty()) {
            MimeMultipart mimeMultipart = new MimeMultipart();
            if (email.getMessage() != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setContent((Object)email.getMessage(), email.getMessageContentType() + "; charset=" + email.getCharset());
                mimeMultipart.addBodyPart((BodyPart)textPart);
            }
            for (Attachment attachment : email.getAttachments()) {
                mimeMultipart.addBodyPart((BodyPart)attachment.getMimeBodyPart());
            }
            message.setContent((Multipart)mimeMultipart);
        } else if (email.getMessage() != null) {
            message.setContent((Object)email.getMessage(), email.getMessageContentType() + "; charset=" + email.getCharset());
        }
        return message;
    }
}

